/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.logtail;

import java.util.regex.Pattern;

public class LogEvent {
    private static final Pattern COMMA = Pattern.compile(",");
    private final long timeStamp;
    private final String source;
    private final LogLevel level;
    private final String message;

    public LogEvent(long timeStamp, String source, LogLevel level, String message) {
        this.timeStamp = timeStamp;
        this.source = source;
        this.level = level;
        this.message = message;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getSource() {
        return this.source;
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public String toCSV() {
        return this.timeStamp + "," + this.source + ',' + this.level.name() + ',' + this.message;
    }

    public String toString() {
        return "LogEvent{timeStamp=" + this.timeStamp + ", source='" + this.source + '\'' + ", level=" + (Object)((Object)this.level) + ", message='" + this.message + '\'' + '}';
    }

    public static LogEvent fromCSV(String csvLine) {
        String[] parts = COMMA.split(csvLine.trim());
        return new LogEvent(Long.valueOf(parts[0]), parts[1], LogLevel.valueOf(parts[2]), parts[3]);
    }

    public static LogEvent randomLogEvent(String source) {
        return new LogEvent(System.currentTimeMillis(), source, LogLevel.values()[(int)(Math.random() * (double)LogLevel.values().length)], "rx-netty sse example");
    }

    public static enum LogLevel {
        ERROR,
        INFO,
        DEBUG;

    }
}

