/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.helloworld;

import io.netty.buffer.ByteBuf;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.protocol.http.server.HttpServer;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import java.util.Map;

public final class HelloWorldServer {
    static final int DEFAULT_PORT = 8090;
    private final int port;

    public HelloWorldServer(int port) {
        this.port = port;
    }

    public HttpServer<ByteBuf, ByteBuf> createServer() {
        return RxNetty.createHttpServer((int)this.port, (request, response) -> {
            this.printRequestHeader((HttpServerRequest<ByteBuf>)request);
            return response.writeStringAndFlush("Hello World!");
        });
    }

    public void printRequestHeader(HttpServerRequest<ByteBuf> request) {
        System.out.println("New request received");
        System.out.println(request.getHttpMethod() + " " + request.getUri() + ' ' + request.getHttpVersion());
        for (Map.Entry header : request.getHeaders().entries()) {
            System.out.println((String)header.getKey() + ": " + (String)header.getValue());
        }
    }

    public static void main(String[] args) {
        System.out.println("HTTP hello world server starting ...");
        new HelloWorldServer(8090).createServer().startAndWait();
    }
}

