/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.helloworld;

import io.netty.buffer.ByteBuf;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class HelloWorldClient {
    private final int port;

    public HelloWorldClient(int port) {
        this.port = port;
    }

    public String sendHelloRequest() throws InterruptedException, ExecutionException, TimeoutException {
        return (String)RxNetty.createHttpGet((String)("http://localhost:" + this.port + "/hello")).flatMap(response -> {
            this.printResponseHeader((HttpClientResponse<ByteBuf>)response);
            return response.getContent().map(content -> content.toString(Charset.defaultCharset()));
        }).toBlocking().toFuture().get(1L, TimeUnit.MINUTES);
    }

    public void printResponseHeader(HttpClientResponse<ByteBuf> response) {
        System.out.println("New response received.");
        System.out.println("========================");
        System.out.println(response.getHttpVersion().text() + ' ' + response.getStatus().code() + ' ' + response.getStatus().reasonPhrase());
        for (Map.Entry header : response.getHeaders().entries()) {
            System.out.println((String)header.getKey() + ": " + (String)header.getValue());
        }
    }

    public static void main(String[] args) throws InterruptedException, ExecutionException, TimeoutException {
        int port = 8090;
        if (args.length > 0) {
            port = Integer.parseInt(args[0]);
        }
        String value = new HelloWorldClient(port).sendHelloRequest();
        System.out.println(value);
        System.out.println("========================");
    }
}

