/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.cpuintensive;

import io.netty.buffer.ByteBuf;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.pipeline.PipelineConfigurators;
import io.reactivex.netty.protocol.http.server.HttpServer;
import io.reactivex.netty.protocol.http.server.HttpServerBuilder;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import java.util.Map;

public final class CPUIntensiveServer {
    static final int DEFAULT_PORT = 8790;
    public static final String IN_EVENT_LOOP_HEADER_NAME = "in_event_loop";
    private final int port;

    public CPUIntensiveServer(int port) {
        this.port = port;
    }

    public HttpServer<ByteBuf, ByteBuf> createServer() {
        HttpServer server = ((HttpServerBuilder)RxNetty.newHttpServerBuilder((int)this.port, (request, response) -> {
            this.printRequestHeader((HttpServerRequest<ByteBuf>)request);
            response.getHeaders().set(IN_EVENT_LOOP_HEADER_NAME, (Object)response.getChannel().eventLoop().inEventLoop());
            response.writeString("Welcome!!");
            return response.close(false);
        }).pipelineConfigurator(PipelineConfigurators.httpServerConfigurator())).withRequestProcessingThreads(50).build();
        return server;
    }

    public void printRequestHeader(HttpServerRequest<ByteBuf> request) {
        System.out.println("New request received");
        System.out.println(request.getHttpMethod() + " " + request.getUri() + ' ' + request.getHttpVersion());
        for (Map.Entry header : request.getHeaders().entries()) {
            System.out.println((String)header.getKey() + ": " + (String)header.getValue());
        }
    }

    public static void main(String[] args) {
        new CPUIntensiveServer(8790).createServer().startAndWait();
    }
}

