/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.chunk;

import io.reactivex.netty.RxNetty;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientPipelineConfigurator;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import rx.Observable;
import rx.Subscriber;

public class HttpChunkClient {
    private final int port;

    public HttpChunkClient(int port) {
        this.port = port;
    }

    public int filterWords(String word) {
        HttpClientPipelineConfigurator configurator = new HttpClientPipelineConfigurator();
        HttpClient client = RxNetty.createHttpClient((String)"localhost", (int)this.port, (PipelineConfigurator)configurator);
        return (Integer)client.submit(HttpClientRequest.createGet((String)"/chunkedResponse")).flatMap(response -> response.getContent().map(content -> content.toString(Charset.defaultCharset()))).lift((Observable.Operator)new WordSplitOperator()).map(someWord -> someWord.equals(word) ? 1 : 0).reduce((accumulator, value) -> accumulator + value).toBlocking().last();
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("ERROR: give 'word' parameter");
            System.exit(-1);
        }
        String word = args[0];
        System.out.println("Sending GET request...");
        System.out.printf("Counted %d words '%s'", new HttpChunkClient(8103).filterWords(word), word);
    }

    static class WordSplitOperator
    implements Observable.Operator<String, String> {
        private static final Pattern WORD_BOUNDARY_PATTERN = Pattern.compile("[^\\w]{1,}");
        private String lastFragment = "";

        WordSplitOperator() {
        }

        public Subscriber<? super String> call(final Subscriber<? super String> child) {
            return new Subscriber<String>(){

                public void onCompleted() {
                    if (!lastFragment.isEmpty()) {
                        child.onNext((Object)lastFragment);
                    }
                    child.onCompleted();
                }

                public void onError(Throwable e) {
                    child.onError(e);
                }

                public void onNext(String text) {
                    if (text.isEmpty()) {
                        return;
                    }
                    String[] words = WORD_BOUNDARY_PATTERN.split(lastFragment + text);
                    int take = words.length;
                    if (Character.isLetter(text.charAt(text.length() - 1))) {
                        lastFragment = words[--take];
                    } else {
                        lastFragment = "";
                    }
                    for (int i = 0; i < take; ++i) {
                        child.onNext((Object)words[i]);
                    }
                }
            };
        }
    }
}

