/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.udp;

import io.netty.buffer.ByteBuf;
import io.netty.channel.socket.DatagramPacket;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.channel.ConnectionHandler;
import io.reactivex.netty.channel.ObservableConnection;
import io.reactivex.netty.protocol.udp.server.UdpServer;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import rx.Observable;
import rx.functions.Func1;

public final class HelloUdpServer {
    static final int DEFAULT_PORT = 8098;
    static final String WELCOME_MSG = "Welcome to the broadcast world!";
    static final byte[] WELCOME_MSG_BYTES = "Welcome to the broadcast world!".getBytes(Charset.defaultCharset());
    public final int port;

    public HelloUdpServer(int port) {
        this.port = port;
    }

    public UdpServer<DatagramPacket, DatagramPacket> createServer() {
        UdpServer server = RxNetty.createUdpServer((int)this.port, (ConnectionHandler)new ConnectionHandler<DatagramPacket, DatagramPacket>(){

            public Observable<Void> handle(final ObservableConnection<DatagramPacket, DatagramPacket> newConnection) {
                return newConnection.getInput().flatMap((Func1)new Func1<DatagramPacket, Observable<Void>>(){

                    public Observable<Void> call(DatagramPacket received) {
                        InetSocketAddress sender = (InetSocketAddress)received.sender();
                        System.out.println("Received datagram. Sender: " + sender + ", data: " + ((ByteBuf)received.content()).toString(Charset.defaultCharset()));
                        ByteBuf data = newConnection.getChannel().alloc().buffer(WELCOME_MSG_BYTES.length);
                        data.writeBytes(WELCOME_MSG_BYTES);
                        return newConnection.writeAndFlush((Object)new DatagramPacket(data, sender));
                    }
                });
            }
        });
        System.out.println("UDP hello server started...");
        return server;
    }

    public static void main(String[] args) {
        new HelloUdpServer(8098).createServer().startAndWait();
    }
}

