/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.tcp.interval;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.string.StringDecoder;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.channel.ObservableConnection;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import rx.Observable;
import rx.functions.Func1;

public final class TcpIntervalClientTakeN {
    private final int port;
    private final int noOfMsg;

    public TcpIntervalClientTakeN(int port, int noOfMsg) {
        this.port = port;
        this.noOfMsg = noOfMsg;
    }

    public int collectMessages() {
        Observable connectionObservable = RxNetty.createTcpClient((String)"localhost", (int)this.port, (PipelineConfigurator)new PipelineConfigurator<String, ByteBuf>(){

            public void configureNewPipeline(ChannelPipeline pipeline) {
                pipeline.addLast(new ChannelHandler[]{new StringDecoder()});
            }
        }).connect();
        Iterable msgIterable = connectionObservable.flatMap((Func1)new Func1<ObservableConnection<String, ByteBuf>, Observable<String>>(){

            public Observable<String> call(ObservableConnection<String, ByteBuf> connection) {
                ByteBuf request = Unpooled.copiedBuffer((byte[])"subscribe:".getBytes());
                Observable subscribeWrite = connection.writeAndFlush((Object)request).map((Func1)new Func1<Void, String>(){

                    public String call(Void aVoid) {
                        return "";
                    }
                });
                Observable data = connection.getInput().map((Func1)new Func1<String, String>(){

                    public String call(String msg) {
                        return msg.trim();
                    }
                });
                return Observable.concat((Observable)subscribeWrite, (Observable)data);
            }
        }).take(this.noOfMsg).toBlocking().toIterable();
        int count = 0;
        for (String m : msgIterable) {
            System.out.println("onNext: " + m);
            ++count;
        }
        return count;
    }

    public static void main(String[] args) {
        int noOfMsg = 100;
        if (args.length > 0) {
            noOfMsg = Integer.valueOf(args[0]);
        }
        new TcpIntervalClientTakeN(8101, noOfMsg).collectMessages();
    }
}

