/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.tcp.echo;

import io.reactivex.netty.RxNetty;
import io.reactivex.netty.channel.ConnectionHandler;
import io.reactivex.netty.channel.ObservableConnection;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.pipeline.PipelineConfigurators;
import io.reactivex.netty.server.RxServer;
import rx.Observable;
import rx.functions.Func1;

public final class TcpEchoServer {
    static final int DEFAULT_PORT = 8099;
    private final int port;

    public TcpEchoServer(int port) {
        this.port = port;
    }

    public RxServer<String, String> createServer() {
        RxServer server = RxNetty.createTcpServer((int)this.port, (PipelineConfigurator)PipelineConfigurators.textOnlyConfigurator(), (ConnectionHandler)new ConnectionHandler<String, String>(){

            public Observable<Void> handle(final ObservableConnection<String, String> connection) {
                System.out.println("New client connection established.");
                connection.writeAndFlush((Object)"Welcome! \n\n");
                return connection.getInput().flatMap((Func1)new Func1<String, Observable<Void>>(){

                    public Observable<Void> call(String msg) {
                        System.out.println("onNext: " + msg);
                        msg = msg.trim();
                        if (!msg.isEmpty()) {
                            return connection.writeAndFlush((Object)("echo => " + msg + '\n'));
                        }
                        return Observable.empty();
                    }
                });
            }
        });
        System.out.println("TCP echo server started...");
        return server;
    }

    public static void main(String[] args) {
        new TcpEchoServer(8099).createServer().startAndWait();
    }
}

