/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.wordcounter;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.logging.LogLevel;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.channel.ContentTransformer;
import io.reactivex.netty.channel.StringTransformer;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.pipeline.PipelineConfigurators;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientBuilder;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.subscriptions.Subscriptions;

public class WordCounterClient {
    private final int port;
    private final String textFile;

    public WordCounterClient(int port, String textFile) {
        this.port = port;
        this.textFile = textFile;
    }

    public int countWords() throws IOException {
        PipelineConfigurator pipelineConfigurator = PipelineConfigurators.httpClientConfigurator();
        HttpClient client = (HttpClient)((HttpClientBuilder)((HttpClientBuilder)RxNetty.newHttpClientBuilder((String)"localhost", (int)this.port).pipelineConfigurator(pipelineConfigurator)).enableWireLogging(LogLevel.ERROR)).build();
        HttpClientRequest request = HttpClientRequest.create((HttpMethod)HttpMethod.POST, (String)"test/post");
        FileContentSource fileContentSource = new FileContentSource(new File(this.textFile));
        request.withRawContentSource((Observable)fileContentSource, (ContentTransformer)StringTransformer.DEFAULT_INSTANCE);
        return (Integer)client.submit(request).flatMap((Func1)new Func1<HttpClientResponse<ByteBuf>, Observable<Integer>>(){

            public Observable<Integer> call(HttpClientResponse<ByteBuf> response) {
                return response.getContent().map((Func1)new Func1<ByteBuf, Integer>(){

                    public Integer call(ByteBuf byteBuf) {
                        return Integer.parseInt(byteBuf.toString(Charset.defaultCharset()));
                    }
                });
            }
        }).toBlocking().single();
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("ERROR: give text file name");
            return;
        }
        String textFile = args[0];
        try {
            int count = new WordCounterClient(8097, textFile).countWords();
            System.out.printf("Counted %d words in text file %s", count, textFile);
        }
        catch (IOException e) {
            System.err.println("ERROR: there is a problem with reading file " + textFile);
        }
    }

    static class FileContentSource
    extends Observable<String> {
        FileContentSource(final File file) {
            super((Observable.OnSubscribe)new Observable.OnSubscribe<String>(){

                public void call(Subscriber<? super String> subscriber) {
                    try {
                        String nextLine;
                        final LineNumberReader reader = new LineNumberReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(file))));
                        subscriber.add(Subscriptions.create((Action0)new Action0(){

                            public void call() {
                                try {
                                    reader.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }));
                        while ((nextLine = reader.readLine()) != null) {
                            subscriber.onNext((Object)nextLine);
                        }
                        subscriber.onCompleted();
                    }
                    catch (Throwable throwable) {
                        subscriber.onError(throwable);
                    }
                }
            });
        }
    }
}

