/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.examples.http.sse;

import io.reactivex.netty.RxNetty;
import io.reactivex.netty.pipeline.PipelineConfigurator;
import io.reactivex.netty.pipeline.PipelineConfigurators;
import io.reactivex.netty.protocol.http.client.HttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.reactivex.netty.protocol.http.sse.ServerSentEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;

public final class HttpSseClient {
    static final int DEFAULT_NO_OF_EVENTS = 100;
    private final int port;
    private final int noOfEvents;

    public HttpSseClient(int port, int noOfEvents) {
        this.port = port;
        this.noOfEvents = noOfEvents;
    }

    public List<ServerSentEvent> readServerSideEvents() {
        HttpClient client = RxNetty.createHttpClient((String)"localhost", (int)this.port, (PipelineConfigurator)PipelineConfigurators.clientSseConfigurator());
        Iterable eventIterable = client.submit(HttpClientRequest.createGet((String)"/hello")).flatMap((Func1)new Func1<HttpClientResponse<ServerSentEvent>, Observable<ServerSentEvent>>(){

            public Observable<ServerSentEvent> call(HttpClientResponse<ServerSentEvent> response) {
                HttpSseClient.printResponseHeader((HttpClientResponse<ServerSentEvent>)response);
                return response.getContent();
            }
        }).take(this.noOfEvents).toBlocking().toIterable();
        ArrayList<ServerSentEvent> events = new ArrayList<ServerSentEvent>();
        for (ServerSentEvent event : eventIterable) {
            System.out.println(event);
            events.add(event);
        }
        return events;
    }

    private static void printResponseHeader(HttpClientResponse<ServerSentEvent> response) {
        System.out.println("New response received.");
        System.out.println("========================");
        System.out.println(response.getHttpVersion().text() + ' ' + response.getStatus().code() + ' ' + response.getStatus().reasonPhrase());
        for (Map.Entry header : response.getHeaders().entries()) {
            System.out.println((String)header.getKey() + ": " + (String)header.getValue());
        }
    }

    public static void main(String[] args) {
        new HttpSseClient(8096, 100).readServerSideEvents();
    }
}

