/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.contexts;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import io.reactivex.netty.contexts.ContextCapturer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ContextAwareEventLoopGroup
implements EventLoopGroup {
    private final EventLoopGroup delegate;
    private final ContextCapturer capturer;

    public ContextAwareEventLoopGroup(EventLoopGroup delegate, ContextCapturer capturer) {
        this.delegate = delegate;
        this.capturer = capturer;
    }

    public EventLoop next() {
        return this.delegate.next();
    }

    public ChannelFuture register(Channel channel) {
        return this.delegate.register(channel);
    }

    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        return this.delegate.register(channel, promise);
    }

    public boolean isShuttingDown() {
        return this.delegate.isShuttingDown();
    }

    public Iterator<EventExecutor> iterator() {
        return this.delegate.iterator();
    }

    public <E extends EventExecutor> Set<E> children() {
        return this.delegate.children();
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.delegate.schedule(this.capturer.makeClosure(callable), delay, unit);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.delegate.schedule(this.capturer.makeClosure(command), delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.delegate.scheduleAtFixedRate(this.capturer.makeClosure(command), initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.delegate.scheduleWithFixedDelay(this.capturer.makeClosure(command), initialDelay, delay, unit);
    }

    @Deprecated
    public void shutdown() {
        this.delegate.shutdown();
    }

    public io.netty.util.concurrent.Future<?> shutdownGracefully() {
        return this.delegate.shutdownGracefully();
    }

    public io.netty.util.concurrent.Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        return this.delegate.shutdownGracefully(quietPeriod, timeout, unit);
    }

    @Deprecated
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    public <T> io.netty.util.concurrent.Future<T> submit(Callable<T> task) {
        return this.delegate.submit(this.capturer.makeClosure(task));
    }

    public io.netty.util.concurrent.Future<?> submit(Runnable task) {
        return this.delegate.submit(this.capturer.makeClosure(task));
    }

    public <T> io.netty.util.concurrent.Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(this.capturer.makeClosure(task), result);
    }

    public io.netty.util.concurrent.Future<?> terminationFuture() {
        return this.delegate.terminationFuture();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        Collection<Callable<T>> decoratedTasks = this.decorateCallables(tasks);
        return this.delegate.invokeAll(decoratedTasks);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        Collection<Callable<T>> decoratedTasks = this.decorateCallables(tasks);
        return this.delegate.invokeAll(decoratedTasks, timeout, unit);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        Collection<Callable<T>> decoratedTasks = this.decorateCallables(tasks);
        return (T)this.delegate.invokeAny(decoratedTasks);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Collection<Callable<T>> decoratedTasks = this.decorateCallables(tasks);
        return (T)this.delegate.invokeAny(decoratedTasks, timeout, unit);
    }

    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    public void execute(Runnable command) {
        this.delegate.execute(command);
    }

    private <T> Collection<Callable<T>> decorateCallables(Collection<? extends Callable<T>> tasks) {
        ArrayList<Callable<T>> allTasks = new ArrayList<Callable<T>>(tasks.size());
        Iterator<Callable<T>> iterator = tasks.iterator();
        while (iterator.hasNext()) {
            Callable<T> task = iterator.next();
            allTasks.add(this.capturer.makeClosure(task));
            iterator.remove();
        }
        return allTasks;
    }
}

