/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results.format;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.TreeSet;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.results.format.ResultFormat;

class XSVResultFormat
implements ResultFormat {
    private final PrintWriter pw;
    private final String delimiter;

    public XSVResultFormat(PrintWriter pw, String delimiter) {
        this.pw = pw;
        this.delimiter = delimiter;
    }

    @Override
    public void writeOut(Collection<RunResult> results) {
        TreeSet params = new TreeSet();
        for (RunResult rs : results) {
            params.addAll(rs.getParams().getParamsKeys());
        }
        this.pw.write("\"Benchmark\"");
        this.pw.write(this.delimiter);
        this.pw.write("\"Mode\"");
        this.pw.write(this.delimiter);
        this.pw.write("\"Threads\"");
        this.pw.write(this.delimiter);
        this.pw.write("\"Samples\"");
        this.pw.write(this.delimiter);
        this.pw.write("\"Score\"");
        this.pw.write(this.delimiter);
        this.pw.write("\"Score Error (99.9%)\"");
        this.pw.write(this.delimiter);
        this.pw.write("\"Unit\"");
        for (String k : params) {
            this.pw.write(this.delimiter);
            this.pw.write("\"Param: " + k + "\"");
        }
        this.pw.write("\r\n");
        for (RunResult runResult : results) {
            BenchmarkParams benchmarkParams = runResult.getParams();
            Result primaryResult = runResult.getPrimaryResult();
            this.pw.write("\"");
            this.pw.write(benchmarkParams.getBenchmark());
            this.pw.write("\"");
            this.pw.write(this.delimiter);
            this.pw.write("\"");
            this.pw.write(benchmarkParams.getMode().shortLabel());
            this.pw.write("\"");
            this.pw.write(this.delimiter);
            this.pw.write(String.valueOf(benchmarkParams.getThreads()));
            this.pw.write(this.delimiter);
            this.pw.write(String.valueOf(primaryResult.getSampleCount()));
            this.pw.write(this.delimiter);
            this.pw.write(String.valueOf(primaryResult.getScore()));
            this.pw.write(this.delimiter);
            this.pw.write(String.valueOf(primaryResult.getScoreError()));
            this.pw.write(this.delimiter);
            this.pw.write("\"");
            this.pw.write(primaryResult.getScoreUnit());
            this.pw.write("\"");
            for (String p : params) {
                this.pw.write(this.delimiter);
                this.pw.write("\"");
                String v = benchmarkParams.getParam(p);
                if (v != null) {
                    this.pw.write(v);
                }
                this.pw.write("\"");
            }
            this.pw.write("\r\n");
        }
    }
}

