/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.ArrayList;
import java.util.Collection;
import rx.Observable;
import rx.exceptions.CompositeException;
import rx.exceptions.Exceptions;
import rx.functions.Action1;
import rx.internal.operators.NotificationLite;
import rx.subjects.Subject;
import rx.subjects.SubjectSubscriptionManager;

public final class BehaviorSubject<T>
extends Subject<T, T> {
    private final SubjectSubscriptionManager<T> state;
    private final NotificationLite<T> nl = NotificationLite.instance();

    public static <T> BehaviorSubject<T> create() {
        return BehaviorSubject.create(null, false);
    }

    public static <T> BehaviorSubject<T> create(T defaultValue) {
        return BehaviorSubject.create(defaultValue, true);
    }

    private static <T> BehaviorSubject<T> create(T defaultValue, boolean hasDefault) {
        final SubjectSubscriptionManager state = new SubjectSubscriptionManager();
        if (hasDefault) {
            state.set(NotificationLite.instance().next(defaultValue));
        }
        state.onAdded = new Action1<SubjectSubscriptionManager.SubjectObserver<T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<T> o) {
                o.emitFirst(state.get(), state.nl);
            }
        };
        state.onTerminated = state.onAdded;
        return new BehaviorSubject(state, state);
    }

    protected BehaviorSubject(Observable.OnSubscribe<T> onSubscribe, SubjectSubscriptionManager<T> state) {
        super(onSubscribe);
        this.state = state;
    }

    @Override
    public void onCompleted() {
        Object last = this.state.get();
        if (last == null || this.state.active) {
            Object n = this.nl.completed();
            for (SubjectSubscriptionManager.SubjectObserver bo : this.state.terminate(n)) {
                bo.emitNext(n, this.state.nl);
            }
        }
    }

    @Override
    public void onError(Throwable e) {
        Object last = this.state.get();
        if (last == null || this.state.active) {
            Object n = this.nl.error(e);
            ArrayList<Throwable> errors = null;
            for (SubjectSubscriptionManager.SubjectObserver bo : this.state.terminate(n)) {
                try {
                    bo.emitNext(n, this.state.nl);
                }
                catch (Throwable e2) {
                    if (errors == null) {
                        errors = new ArrayList<Throwable>();
                    }
                    errors.add(e2);
                }
            }
            if (errors != null) {
                if (errors.size() == 1) {
                    Exceptions.propagate((Throwable)errors.get(0));
                } else {
                    throw new CompositeException("Errors while emitting AsyncSubject.onError", (Collection<? extends Throwable>)errors);
                }
            }
        }
    }

    @Override
    public void onNext(T v) {
        Object last = this.state.get();
        if (last == null || this.state.active) {
            Object n = this.nl.next(v);
            for (SubjectSubscriptionManager.SubjectObserver bo : this.state.next(n)) {
                bo.emitNext(n, this.state.nl);
            }
        }
    }

    int subscriberCount() {
        return this.state.observers().length;
    }

    @Override
    public boolean hasObservers() {
        return this.state.observers().length > 0;
    }
}

