/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.io.IOException;
import org.openjdk.jmh.runner.ForkedRunner;
import org.openjdk.jmh.runner.link.BinaryLinkClient;
import org.openjdk.jmh.runner.options.Options;

class ForkedMain {
    ForkedMain() {
    }

    public static void main(String[] argv) {
        if (argv.length == 0) {
            throw new IllegalArgumentException("Empty arguments for forked VM");
        }
        BinaryLinkClient link = null;
        try {
            String hostName = argv[0];
            int hostPort = Integer.valueOf(argv[1]);
            link = new BinaryLinkClient(hostName, hostPort);
            Options options = link.requestOptions();
            System.setErr(link.getErrStream());
            System.setOut(link.getOutStream());
            ForkedRunner runner = new ForkedRunner(options, link);
            runner.run();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        finally {
            if (link != null) {
                try {
                    link.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

