/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.lang.reflect.Method;
import java.util.Collection;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.ThreadParams;
import org.openjdk.jmh.runner.BenchmarkHandler;
import org.openjdk.jmh.runner.InfraControl;
import org.openjdk.jmh.runner.LoopBenchmarkHandler;
import org.openjdk.jmh.runner.format.OutputFormat;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.util.ClassUtils;

class BenchmarkHandlers {
    private BenchmarkHandlers() {
    }

    public static Method findBenchmarkMethod(Class<?> clazz, String methodName) {
        Method method = null;
        for (Method m : ClassUtils.enumerateMethods(clazz)) {
            if (!m.getName().equals(methodName)) continue;
            if (BenchmarkHandlers.isValidBenchmarkSignature(m)) {
                if (method != null) {
                    throw new IllegalArgumentException("Ambiguous methods: \n" + method + "\n and \n" + m + "\n, which one to execute?");
                }
                method = m;
                continue;
            }
            throw new IllegalArgumentException("Benchmark parameters do not match the signature contract.");
        }
        if (method == null) {
            throw new IllegalArgumentException("No matching methods found in benchmark");
        }
        return method;
    }

    public static BenchmarkHandler getInstance(OutputFormat out, Class<?> clazz, Method method, BenchmarkParams executionParams, Options options) {
        return new LoopBenchmarkHandler(out, clazz, method, options, executionParams);
    }

    private static boolean isValidBenchmarkSignature(Method m) {
        if (m.getReturnType() != Collection.class) {
            return false;
        }
        Class<?>[] parameterTypes = m.getParameterTypes();
        if (parameterTypes.length != 2) {
            return false;
        }
        if (parameterTypes[0] != InfraControl.class) {
            return false;
        }
        return parameterTypes[1] == ThreadParams.class;
    }
}

