/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.util.HashMultiset;
import org.openjdk.jmh.util.ListStatistics;
import org.openjdk.jmh.util.Multiset;
import org.openjdk.jmh.util.Multisets;

public class StackProfiler
implements InternalProfiler {
    private static final int SAMPLE_STACK_LINES = Integer.getInteger("jmh.stack.lines", 1);
    private static final int SAMPLE_TOP_STACKS = Integer.getInteger("jmh.stack.top", 10);
    private static final int SAMPLE_PERIOD_MSEC = Integer.getInteger("jmh.stack.period", 10);
    private static final boolean SAMPLE_LINE = Boolean.getBoolean("jmh.stack.detailLine");
    private static final String[] IGNORED_THREADS = new String[]{"Finalizer", "Signal Dispatcher", "Reference Handler", "LoopTimer", "main", "Sampling Thread", "Attach Listener"};
    private volatile SamplingTask samplingTask;

    @Override
    public void beforeIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        this.samplingTask = new SamplingTask();
        this.samplingTask.start();
    }

    @Override
    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        this.samplingTask.stop();
        return Arrays.asList(new StackResult(this.samplingTask.stacks));
    }

    @Override
    public Collection<String> checkSupport() {
        return Collections.emptyList();
    }

    @Override
    public String label() {
        return "stack";
    }

    @Override
    public String getDescription() {
        return "Simple and naive Java stack profiler";
    }

    public static class StackResultAggregator
    implements Aggregator<StackResult> {
        @Override
        public Result aggregate(Collection<StackResult> results) {
            HashMultiset<StackRecord> sum = new HashMultiset<StackRecord>();
            for (StackResult r : results) {
                for (StackRecord rec : r.stacks.keys()) {
                    sum.add(rec, r.stacks.count(rec));
                }
            }
            return new StackResult(sum);
        }
    }

    public static class StackResult
    extends Result<StackResult> {
        private final Multiset<StackRecord> stacks;

        public StackResult(Multiset<StackRecord> stacks) {
            super(ResultRole.SECONDARY, "@stack", new ListStatistics(), "none", AggregationPolicy.AVG);
            this.stacks = stacks;
        }

        @Override
        protected Aggregator<StackResult> getThreadAggregator() {
            return new StackResultAggregator();
        }

        @Override
        protected Aggregator<StackResult> getIterationAggregator() {
            return new StackResultAggregator();
        }

        @Override
        public String toString() {
            return "<delayed till summary>";
        }

        @Override
        public String extendedInfo(String label) {
            return this.getStack(this.stacks);
        }

        public String getStack(Multiset<StackRecord> stacks) {
            Collection<StackRecord> cut = Multisets.countHighest(stacks, SAMPLE_TOP_STACKS);
            StringBuilder builder = new StringBuilder();
            builder.append("Stack profiler:\n");
            int totalDisplayed = 0;
            int count = 0;
            for (StackRecord s : cut) {
                if (count++ > SAMPLE_TOP_STACKS) break;
                String[] lines = s.lines;
                if (lines.length <= 0) continue;
                totalDisplayed += stacks.count(s);
                builder.append(String.format("%5.1f%% %10s %s\n", new Object[]{(double)stacks.count(s) * 100.0 / (double)stacks.size(), s.threadState, lines[0]}));
                if (lines.length <= 1) continue;
                for (int i = 1; i < lines.length; ++i) {
                    builder.append(String.format("%5s  %10s %s\n", "", "", lines[i]));
                }
                builder.append("\n");
            }
            builder.append(String.format("%5.1f%% %10s %s\n", (double)(stacks.size() - totalDisplayed) * 100.0 / (double)stacks.size(), "", "(other)"));
            return builder.toString();
        }
    }

    private static class StackRecord
    implements Serializable {
        public final Thread.State threadState;
        public final String[] lines;

        private StackRecord(Thread.State threadState, String[] lines) {
            this.threadState = threadState;
            this.lines = lines;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StackRecord that = (StackRecord)o;
            if (!Arrays.equals(this.lines, that.lines)) {
                return false;
            }
            return this.threadState == that.threadState;
        }

        public int hashCode() {
            int result = this.threadState != null ? this.threadState.hashCode() : 0;
            result = 31 * result + (this.lines != null ? Arrays.hashCode(this.lines) : 0);
            return result;
        }
    }

    public static class SamplingTask
    implements Runnable {
        private final Thread thread;
        private final Multiset<StackRecord> stacks = new HashMultiset<StackRecord>();

        public SamplingTask() {
            this.thread = new Thread(this);
            this.thread.setName("Sampling Thread");
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                ThreadInfo[] infos;
                block3: for (ThreadInfo info : infos = ManagementFactory.getThreadMXBean().dumpAllThreads(false, false)) {
                    for (String ignore : IGNORED_THREADS) {
                        if (info.getThreadName().equalsIgnoreCase(ignore)) continue block3;
                    }
                    StackTraceElement[] stack = info.getStackTrace();
                    String[] stackLines = new String[Math.min(stack.length, SAMPLE_STACK_LINES)];
                    for (int i = 0; i < Math.min(stack.length, SAMPLE_STACK_LINES); ++i) {
                        stackLines[i] = stack[i].getClassName() + '.' + stack[i].getMethodName() + (SAMPLE_LINE ? ":" + stack[i].getLineNumber() : "");
                    }
                    this.stacks.add(new StackRecord(info.getThreadState(), stackLines));
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(SAMPLE_PERIOD_MSEC);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        public void start() {
            this.thread.start();
        }

        public void stop() {
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

