/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.reactivex.netty.channel.ObservableConnection;
import io.reactivex.netty.client.ClientChannelFactory;
import io.reactivex.netty.client.ClientConnectionFactory;
import io.reactivex.netty.client.ClientMetricsEvent;
import io.reactivex.netty.client.ConnectionLifecycleHandler;
import io.reactivex.netty.client.RxClient;
import io.reactivex.netty.metrics.Clock;
import io.reactivex.netty.metrics.MetricEventsSubject;
import rx.Subscriber;
import rx.functions.Action0;
import rx.subscriptions.Subscriptions;

public class ClientChannelFactoryImpl<I, O>
implements ClientChannelFactory<I, O> {
    protected final Bootstrap clientBootstrap;
    private MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject;

    public ClientChannelFactoryImpl(Bootstrap clientBootstrap, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        this.clientBootstrap = clientBootstrap;
        this.eventsSubject = eventsSubject;
    }

    public ClientChannelFactoryImpl(Bootstrap clientBootstrap) {
        this(clientBootstrap, new MetricEventsSubject());
    }

    @Override
    public ChannelFuture connect(final Subscriber<? super ObservableConnection<I, O>> subscriber, RxClient.ServerInfo serverInfo, final ClientConnectionFactory<I, O, ? extends ObservableConnection<I, O>> connectionFactory) {
        final long startTimeMillis = Clock.newStartTimeMillis();
        this.eventsSubject.onEvent(ClientMetricsEvent.CONNECT_START);
        final ChannelFuture connectFuture = this.clientBootstrap.connect(serverInfo.getHost(), serverInfo.getPort());
        subscriber.add(Subscriptions.create(new Action0(){

            @Override
            public void call() {
                if (!connectFuture.isDone()) {
                    connectFuture.cancel(true);
                }
            }
        }));
        connectFuture.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                try {
                    if (!future.isSuccess()) {
                        ClientChannelFactoryImpl.this.eventsSubject.onEvent(ClientMetricsEvent.CONNECT_FAILED, Clock.onEndMillis(startTimeMillis), future.cause());
                        subscriber.onError(future.cause());
                    } else {
                        ClientChannelFactoryImpl.this.eventsSubject.onEvent(ClientMetricsEvent.CONNECT_SUCCESS, Clock.onEndMillis(startTimeMillis));
                        ChannelPipeline pipeline = future.channel().pipeline();
                        final Object newConnection = connectionFactory.newConnection(future.channel());
                        ChannelHandler lifecycleHandler = pipeline.get("conn_lifecycle_handler");
                        if (null == lifecycleHandler) {
                            ClientChannelFactoryImpl.this.onNewConnection(newConnection, subscriber);
                        } else {
                            ConnectionLifecycleHandler handler = (ConnectionLifecycleHandler)lifecycleHandler;
                            SslHandler sslHandler = pipeline.get(SslHandler.class);
                            if (null == sslHandler) {
                                handler.setConnection(newConnection);
                                ClientChannelFactoryImpl.this.onNewConnection(newConnection, subscriber);
                            } else {
                                sslHandler.handshakeFuture().addListener((GenericFutureListener<Future<Channel>>)new GenericFutureListener<Future<? super Channel>>(){

                                    @Override
                                    public void operationComplete(Future<? super Channel> future) throws Exception {
                                        ClientChannelFactoryImpl.this.onNewConnection(newConnection, subscriber);
                                    }
                                });
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    subscriber.onError(throwable);
                }
            }
        });
        return connectFuture;
    }

    @Override
    public void onNewConnection(ObservableConnection<I, O> newConnection, Subscriber<? super ObservableConnection<I, O>> subscriber) {
        subscriber.onNext(newConnection);
        subscriber.onCompleted();
    }

    @Override
    public void useMetricEventsSubject(MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        this.eventsSubject = eventsSubject;
    }
}

