/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.openjdk.jmh.runner.AbstractResourceReader;
import org.openjdk.jmh.runner.BenchmarkListEntry;
import org.openjdk.jmh.runner.format.OutputFormat;

public class BenchmarkList
extends AbstractResourceReader {
    public static final String BENCHMARK_LIST = "/META-INF/BenchmarkList";

    public static BenchmarkList defaultList() {
        return BenchmarkList.fromResource(BENCHMARK_LIST);
    }

    public static BenchmarkList fromResource(String resource) {
        return new BenchmarkList(null, resource, null);
    }

    public static BenchmarkList fromFile(String file) {
        return new BenchmarkList(file, null, null);
    }

    public static BenchmarkList fromString(String line) {
        return new BenchmarkList(null, null, line);
    }

    private BenchmarkList(String file, String resource, String line) {
        super(file, resource, line);
    }

    public Set<BenchmarkListEntry> getAll(OutputFormat out, List<String> excludes) {
        return this.find(out, ".*", excludes);
    }

    public Set<BenchmarkListEntry> find(OutputFormat out, String regexp, List<String> excludes) {
        return this.find(out, Collections.singletonList(regexp), excludes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<BenchmarkListEntry> find(OutputFormat out, List<String> regexps, List<String> excludes) {
        if (regexps.isEmpty()) {
            regexps.add(".*");
        }
        ArrayList<Pattern> includePatterns = new ArrayList<Pattern>(regexps.size());
        for (String regexp : regexps) {
            includePatterns.add(Pattern.compile(regexp));
        }
        ArrayList<Pattern> excludePatterns = new ArrayList<Pattern>(excludes.size());
        for (String regexp : excludes) {
            excludePatterns.add(Pattern.compile(regexp));
        }
        TreeSet<BenchmarkListEntry> result = new TreeSet<BenchmarkListEntry>();
        try {
            for (Reader r : this.getReaders()) {
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(r);
                    String line = reader.readLine();
                    while (line != null) {
                        if (!line.startsWith("#") && !line.trim().isEmpty()) {
                            BenchmarkListEntry br = new BenchmarkListEntry(line);
                            for (Pattern pattern : includePatterns) {
                                if (pattern.matcher(br.getUsername()).matches()) {
                                    boolean exclude = false;
                                    for (Pattern excludePattern : excludePatterns) {
                                        if (!excludePattern.matcher(line).matches()) continue;
                                        out.verbosePrintln("Excluding " + br.getUsername() + ", matches " + excludePattern);
                                        exclude = true;
                                        break;
                                    }
                                    if (exclude) break;
                                    result.add(br);
                                    break;
                                }
                                out.verbosePrintln("Excluding: " + br.getUsername() + ", does not match " + pattern);
                            }
                        }
                        line = reader.readLine();
                    }
                }
                finally {
                    if (reader == null) continue;
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading benchmark list", ex);
        }
        return result;
    }
}

