/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.AbstractHotspotProfiler;
import org.openjdk.jmh.profile.ProfilerResult;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Result;
import sun.management.HotspotRuntimeMBean;
import sun.management.counter.Counter;

public class HotspotRuntimeProfiler
extends AbstractHotspotProfiler {
    public List<Counter> getCounters() {
        return ((HotspotRuntimeMBean)AbstractHotspotProfiler.getInstance("HotspotRuntimeMBean")).getInternalRuntimeCounters();
    }

    @Override
    public String label() {
        return "hs_rt";
    }

    @Override
    public String getDescription() {
        return "HotSpot (tm) runtime profiling via implementation-specific MBeans";
    }

    @Override
    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        Map<String, Long> current = this.counters().getCurrent();
        return Arrays.asList(new ProfilerResult("@rt.sync.fatMonitors", current.get("sun.rt._sync_MonExtant").longValue(), "monitors", AggregationPolicy.MAX), new ProfilerResult("@rt.sync.monitorInflations", current.get("sun.rt._sync_Inflations").longValue(), "monitors", AggregationPolicy.MAX), new ProfilerResult("@rt.sync.monitorDeflations", current.get("sun.rt._sync_Deflations").longValue(), "monitors", AggregationPolicy.MAX), new ProfilerResult("@rt.sync.contendedLockAttempts", current.get("sun.rt._sync_ContendedLockAttempts").longValue(), "locks", AggregationPolicy.MAX), new ProfilerResult("@rt.sync.parks", current.get("sun.rt._sync_Parks").longValue(), "counts", AggregationPolicy.MAX), new ProfilerResult("@rt.sync.notifications", current.get("sun.rt._sync_Notifications").longValue(), "counts", AggregationPolicy.MAX), new ProfilerResult("@rt.sync.futileWakeups", current.get("sun.rt._sync_FutileWakeups").longValue(), "counts", AggregationPolicy.MAX), new ProfilerResult("@rt.safepoints", current.get("sun.rt.safepoints").longValue(), "counts", AggregationPolicy.MAX), new ProfilerResult("@rt.safepointSyncTime", TimeUnit.NANOSECONDS.toMillis(current.get("sun.rt.safepointSyncTime")), "ms", AggregationPolicy.MAX), new ProfilerResult("@rt.safepointTime", TimeUnit.NANOSECONDS.toMillis(current.get("sun.rt.safepointTime")), "ms", AggregationPolicy.MAX));
    }
}

