/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.reactivestreams;

import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscription;
import rx.Subscriber;
import rx.internal.reactivestreams.RxJavaSynchronizedProducer;

public class SubscriberAdapter<T>
implements org.reactivestreams.Subscriber<T> {
    private final Subscriber<? super T> rxSubscriber;
    private final AtomicBoolean started = new AtomicBoolean();

    public SubscriberAdapter(Subscriber<? super T> rxSubscriber) {
        this.rxSubscriber = rxSubscriber;
    }

    @Override
    public void onSubscribe(Subscription rsSubscription) {
        if (rsSubscription == null) {
            throw new NullPointerException("onSubscribe(null)");
        }
        if (this.started.compareAndSet(false, true)) {
            RxJavaSynchronizedProducer sp = new RxJavaSynchronizedProducer(rsSubscription);
            this.rxSubscriber.add(sp);
            this.rxSubscriber.onStart();
            this.rxSubscriber.setProducer(sp);
        } else {
            rsSubscription.cancel();
        }
    }

    @Override
    public void onNext(T t) {
        if (t == null) {
            throw new NullPointerException("onNext(null)");
        }
        this.rxSubscriber.onNext(t);
    }

    @Override
    public void onError(Throwable t) {
        if (t == null) {
            throw new NullPointerException("onError(null)");
        }
        this.rxSubscriber.onError(t);
    }

    @Override
    public void onComplete() {
        this.rxSubscriber.onCompleted();
    }
}

