/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.reactivestreams;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import rx.Observable;
import rx.Subscriber;
import rx.internal.operators.BackpressureUtils;

public class PublisherAdapter<T>
implements Publisher<T> {
    private final Observable<T> observable;
    private final ConcurrentMap<org.reactivestreams.Subscriber<?>, Object> subscribers = new ConcurrentHashMap();

    public PublisherAdapter(Observable<T> observable) {
        this.observable = observable.serialize();
    }

    @Override
    public void subscribe(final org.reactivestreams.Subscriber<? super T> s) {
        if (this.subscribers.putIfAbsent(s, s) == null) {
            this.observable.subscribe(new Subscriber<T>(){
                private final AtomicBoolean done = new AtomicBoolean();
                private final AtomicLong childRequested = new AtomicLong();

                private void doRequest(long n) {
                    if (!this.done.get()) {
                        BackpressureUtils.getAndAddRequest(this.childRequested, n);
                        this.request(n);
                    }
                }

                @Override
                public void onStart() {
                    final AtomicBoolean requested = new AtomicBoolean();
                    s.onSubscribe(new Subscription(){

                        @Override
                        public void request(long n) {
                            if (n < 1L) {
                                this.unsubscribe();
                                this.onError(new IllegalArgumentException("3.9 While the Subscription is not cancelled, Subscription.request(long n) MUST throw a java.lang.IllegalArgumentException if the argument is <= 0."));
                                return;
                            }
                            requested.set(true);
                            this.doRequest(n);
                        }

                        @Override
                        public void cancel() {
                            this.unsubscribe();
                            this.fireDone();
                        }
                    });
                    if (!requested.get()) {
                        this.request(0L);
                    }
                }

                private boolean fireDone() {
                    boolean first = this.done.compareAndSet(false, true);
                    if (first) {
                        PublisherAdapter.this.subscribers.remove(s);
                    }
                    return first;
                }

                @Override
                public void onCompleted() {
                    if (this.fireDone()) {
                        s.onComplete();
                    }
                }

                @Override
                public void onError(Throwable e) {
                    if (this.fireDone()) {
                        s.onError(e);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onNext(T t) {
                    if (!this.done.get()) {
                        if (this.childRequested.get() > 0L) {
                            s.onNext(t);
                            this.childRequested.decrementAndGet();
                        } else {
                            try {
                                this.onError(new IllegalStateException("1.1 source doesn't respect backpressure"));
                            }
                            finally {
                                this.unsubscribe();
                            }
                        }
                    }
                }
            });
        } else {
            s.onError(new IllegalArgumentException("1.10 Subscriber cannot subscribe more than once"));
        }
    }
}

