/*
 * Decompiled with CFR 0.152.
 */
package rx.math.operators;

import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

public final class OperatorAverageDouble<T>
implements Observable.Operator<Double, T> {
    final Func1<? super T, Double> valueExtractor;

    public OperatorAverageDouble(Func1<? super T, Double> valueExtractor) {
        this.valueExtractor = valueExtractor;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super Double> child) {
        return new AverageObserver(child);
    }

    private final class AverageObserver
    extends Subscriber<T> {
        final Subscriber<? super Double> child;
        double sum;
        int count;

        public AverageObserver(Subscriber<? super Double> subscriber) {
            super(subscriber);
            this.child = subscriber;
        }

        @Override
        public void onNext(T args) {
            this.sum += OperatorAverageDouble.this.valueExtractor.call(args).doubleValue();
            ++this.count;
        }

        @Override
        public void onError(Throwable e) {
            this.child.onError(e);
        }

        @Override
        public void onCompleted() {
            if (this.count > 0) {
                try {
                    this.child.onNext((Double)(this.sum / (double)this.count));
                }
                catch (Throwable t) {
                    this.child.onError(t);
                    return;
                }
                this.child.onCompleted();
            } else {
                this.child.onError(new IllegalArgumentException("Sequence contains no elements"));
            }
        }
    }
}

