/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.exceptions.CompositeException;
import rx.exceptions.Exceptions;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.internal.operators.NotificationLite;
import rx.internal.util.UtilityFunctions;
import rx.schedulers.Timestamped;
import rx.subjects.Subject;
import rx.subjects.SubjectSubscriptionManager;

public final class ReplaySubject<T>
extends Subject<T, T> {
    final ReplayState<T, ?> state;
    final SubjectSubscriptionManager<T> ssm;

    public static <T> ReplaySubject<T> create() {
        return ReplaySubject.create(16);
    }

    public static <T> ReplaySubject<T> create(int capacity) {
        final UnboundedReplayState state = new UnboundedReplayState(capacity);
        SubjectSubscriptionManager ssm = new SubjectSubscriptionManager();
        ssm.onStart = new Action1<SubjectSubscriptionManager.SubjectObserver<T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<T> o) {
                int lastIndex = state.replayObserverFromIndex(0, o);
                o.index(lastIndex);
            }
        };
        ssm.onTerminated = new Action1<SubjectSubscriptionManager.SubjectObserver<T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<T> o) {
                Integer idx = (Integer)o.index();
                if (idx == null) {
                    idx = 0;
                }
                state.replayObserverFromIndex(idx, o);
            }
        };
        return new ReplaySubject(ssm, ssm, state);
    }

    static <T> ReplaySubject<T> createUnbounded() {
        BoundedState state = new BoundedState(new EmptyEvictionPolicy(), UtilityFunctions.<Object>identity(), UtilityFunctions.<Object>identity());
        return ReplaySubject.createWithState(state, new DefaultOnAdd(state));
    }

    public static <T> ReplaySubject<T> createWithSize(int size) {
        BoundedState state = new BoundedState(new SizeEvictionPolicy(size), UtilityFunctions.<Object>identity(), UtilityFunctions.<Object>identity());
        return ReplaySubject.createWithState(state, new DefaultOnAdd(state));
    }

    public static <T> ReplaySubject<T> createWithTime(long time, TimeUnit unit, Scheduler scheduler) {
        BoundedState state = new BoundedState(new TimeEvictionPolicy(unit.toMillis(time), scheduler), new AddTimestamped(scheduler), new RemoveTimestamped());
        return ReplaySubject.createWithState(state, new TimedOnAdd(state, scheduler));
    }

    public static <T> ReplaySubject<T> createWithTimeAndSize(long time, TimeUnit unit, int size, Scheduler scheduler) {
        BoundedState state = new BoundedState(new PairEvictionPolicy(new SizeEvictionPolicy(size), new TimeEvictionPolicy(unit.toMillis(time), scheduler)), new AddTimestamped(scheduler), new RemoveTimestamped());
        return ReplaySubject.createWithState(state, new TimedOnAdd(state, scheduler));
    }

    static final <T> ReplaySubject<T> createWithState(final BoundedState<T> state, Action1<SubjectSubscriptionManager.SubjectObserver<T>> onStart) {
        SubjectSubscriptionManager ssm = new SubjectSubscriptionManager();
        ssm.onStart = onStart;
        ssm.onTerminated = new Action1<SubjectSubscriptionManager.SubjectObserver<T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<T> t1) {
                NodeList.Node<Object> l = (NodeList.Node<Object>)t1.index();
                if (l == null) {
                    l = state.head();
                }
                state.replayObserverFromIndex(l, t1);
            }
        };
        return new ReplaySubject(ssm, ssm, state);
    }

    ReplaySubject(Observable.OnSubscribe<T> onSubscribe, SubjectSubscriptionManager<T> ssm, ReplayState<T, ?> state) {
        super(onSubscribe);
        this.ssm = ssm;
        this.state = state;
    }

    @Override
    public void onNext(T t) {
        if (this.ssm.active) {
            this.state.next(t);
            for (SubjectSubscriptionManager.SubjectObserver<T> o : this.ssm.observers()) {
                if (!this.caughtUp(o)) continue;
                o.onNext(t);
            }
        }
    }

    @Override
    public void onError(Throwable e) {
        if (this.ssm.active) {
            this.state.error(e);
            ArrayList<Throwable> errors = null;
            for (SubjectSubscriptionManager.SubjectObserver<T> o : this.ssm.terminate(NotificationLite.instance().error(e))) {
                try {
                    if (!this.caughtUp(o)) continue;
                    o.onError(e);
                }
                catch (Throwable e2) {
                    if (errors == null) {
                        errors = new ArrayList<Throwable>();
                    }
                    errors.add(e2);
                }
            }
            if (errors != null) {
                if (errors.size() == 1) {
                    Exceptions.propagate((Throwable)errors.get(0));
                } else {
                    throw new CompositeException("Errors while emitting ReplaySubject.onError", (Collection<? extends Throwable>)errors);
                }
            }
        }
    }

    @Override
    public void onCompleted() {
        if (this.ssm.active) {
            this.state.complete();
            for (SubjectSubscriptionManager.SubjectObserver<T> o : this.ssm.terminate(NotificationLite.instance().completed())) {
                if (!this.caughtUp(o)) continue;
                o.onCompleted();
            }
        }
    }

    int subscriberCount() {
        return this.ssm.state.observers.length;
    }

    @Override
    public boolean hasObservers() {
        return this.ssm.observers().length > 0;
    }

    private boolean caughtUp(SubjectSubscriptionManager.SubjectObserver<? super T> o) {
        if (!o.caughtUp) {
            o.caughtUp = true;
            this.state.replayObserver(o);
            o.index(null);
            return false;
        }
        return true;
    }

    static final class EmptyEvictionPolicy
    implements EvictionPolicy {
        EmptyEvictionPolicy() {
        }

        @Override
        public boolean test(Object value, long now) {
            return true;
        }

        @Override
        public void evict(NodeList<Object> list) {
        }
    }

    static final class NodeList<T> {
        final Node<T> head = new Node<Object>(null);
        Node<T> tail = this.head;
        int size;

        NodeList() {
        }

        public void addLast(T value) {
            Node<T> t = this.tail;
            Node<T> t2 = new Node<T>(value);
            t.next = t2;
            this.tail = t2;
            ++this.size;
        }

        public T removeFirst() {
            if (this.head.next == null) {
                throw new IllegalStateException("Empty!");
            }
            Node t = this.head.next;
            this.head.next = t.next;
            if (this.head.next == null) {
                this.tail = this.head;
            }
            --this.size;
            return t.value;
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public int size() {
            return this.size;
        }

        public void clear() {
            this.tail = this.head;
            this.size = 0;
        }

        static final class Node<T> {
            final T value;
            volatile Node<T> next;

            Node(T value) {
                this.value = value;
            }
        }
    }

    static final class TimedOnAdd<T>
    implements Action1<SubjectSubscriptionManager.SubjectObserver<T>> {
        final BoundedState<T> state;
        final Scheduler scheduler;

        public TimedOnAdd(BoundedState<T> state, Scheduler scheduler) {
            this.state = state;
            this.scheduler = scheduler;
        }

        @Override
        public void call(SubjectSubscriptionManager.SubjectObserver<T> t1) {
            NodeList.Node<Object> l = !this.state.terminated ? this.state.replayObserverFromIndexTest(this.state.head(), t1, this.scheduler.now()) : this.state.replayObserverFromIndex(this.state.head(), t1);
            t1.index(l);
        }
    }

    static final class DefaultOnAdd<T>
    implements Action1<SubjectSubscriptionManager.SubjectObserver<T>> {
        final BoundedState<T> state;

        public DefaultOnAdd(BoundedState<T> state) {
            this.state = state;
        }

        @Override
        public void call(SubjectSubscriptionManager.SubjectObserver<T> t1) {
            NodeList.Node<Object> l = this.state.replayObserverFromIndex(this.state.head(), t1);
            t1.index(l);
        }
    }

    static final class RemoveTimestamped
    implements Func1<Object, Object> {
        RemoveTimestamped() {
        }

        @Override
        public Object call(Object t1) {
            return ((Timestamped)t1).getValue();
        }
    }

    static final class AddTimestamped
    implements Func1<Object, Object> {
        final Scheduler scheduler;

        public AddTimestamped(Scheduler scheduler) {
            this.scheduler = scheduler;
        }

        @Override
        public Object call(Object t1) {
            return new Timestamped<Object>(this.scheduler.now(), t1);
        }
    }

    static final class PairEvictionPolicy
    implements EvictionPolicy {
        final EvictionPolicy first;
        final EvictionPolicy second;

        public PairEvictionPolicy(EvictionPolicy first, EvictionPolicy second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public void evict(NodeList<Object> t1) {
            this.first.evict(t1);
            this.second.evict(t1);
        }

        @Override
        public boolean test(Object value, long now) {
            return this.first.test(value, now) || this.second.test(value, now);
        }
    }

    static final class TimeEvictionPolicy
    implements EvictionPolicy {
        final long maxAgeMillis;
        final Scheduler scheduler;

        public TimeEvictionPolicy(long maxAgeMillis, Scheduler scheduler) {
            this.maxAgeMillis = maxAgeMillis;
            this.scheduler = scheduler;
        }

        @Override
        public void evict(NodeList<Object> t1) {
            long now = this.scheduler.now();
            while (!t1.isEmpty()) {
                NodeList.Node n = t1.head.next;
                if (!this.test(n.value, now)) break;
                t1.removeFirst();
            }
        }

        @Override
        public boolean test(Object value, long now) {
            Timestamped ts = (Timestamped)value;
            return ts.getTimestampMillis() <= now - this.maxAgeMillis;
        }
    }

    static final class SizeEvictionPolicy
    implements EvictionPolicy {
        final int maxSize;

        public SizeEvictionPolicy(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public void evict(NodeList<Object> t1) {
            while (t1.size() > this.maxSize) {
                t1.removeFirst();
            }
        }

        @Override
        public boolean test(Object value, long now) {
            return true;
        }
    }

    static interface EvictionPolicy {
        public boolean test(Object var1, long var2);

        public void evict(NodeList<Object> var1);
    }

    static interface ReplayState<T, I> {
        public boolean terminated();

        public void replayObserver(SubjectSubscriptionManager.SubjectObserver<? super T> var1);

        public I replayObserverFromIndex(I var1, SubjectSubscriptionManager.SubjectObserver<? super T> var2);

        public I replayObserverFromIndexTest(I var1, SubjectSubscriptionManager.SubjectObserver<? super T> var2, long var3);

        public void next(T var1);

        public void error(Throwable var1);

        public void complete();
    }

    static final class BoundedState<T>
    implements ReplayState<T, NodeList.Node<Object>> {
        final NodeList<Object> list;
        final EvictionPolicy evictionPolicy;
        final Func1<Object, Object> enterTransform;
        final Func1<Object, Object> leaveTransform;
        final NotificationLite<T> nl = NotificationLite.instance();
        volatile boolean terminated;
        volatile NodeList.Node<Object> tail;

        public BoundedState(EvictionPolicy evictionPolicy, Func1<Object, Object> enterTransform, Func1<Object, Object> leaveTransform) {
            this.list = new NodeList();
            this.tail = this.list.tail;
            this.evictionPolicy = evictionPolicy;
            this.enterTransform = enterTransform;
            this.leaveTransform = leaveTransform;
        }

        @Override
        public void next(T value) {
            if (!this.terminated) {
                this.list.addLast(this.enterTransform.call(this.nl.next(value)));
                this.evictionPolicy.evict(this.list);
                this.tail = this.list.tail;
            }
        }

        @Override
        public void complete() {
            if (!this.terminated) {
                this.terminated = true;
                this.evictionPolicy.evict(this.list);
                this.list.addLast(this.enterTransform.call(this.nl.completed()));
                this.tail = this.list.tail;
            }
        }

        @Override
        public void error(Throwable e) {
            if (!this.terminated) {
                this.terminated = true;
                this.evictionPolicy.evict(this.list);
                this.list.addLast(this.enterTransform.call(this.nl.error(e)));
                this.tail = this.list.tail;
            }
        }

        public void accept(Observer<? super T> o, NodeList.Node<Object> node) {
            this.nl.accept(o, this.leaveTransform.call(node.value));
        }

        public void acceptTest(Observer<? super T> o, NodeList.Node<Object> node, long now) {
            Object v = node.value;
            if (!this.evictionPolicy.test(v, now)) {
                this.nl.accept(o, this.leaveTransform.call(v));
            }
        }

        public NodeList.Node<Object> head() {
            return this.list.head;
        }

        public NodeList.Node<Object> tail() {
            return this.tail;
        }

        @Override
        public void replayObserver(SubjectSubscriptionManager.SubjectObserver<? super T> observer) {
            NodeList.Node lastEmittedLink = (NodeList.Node)observer.index();
            NodeList.Node<Object> l = this.replayObserverFromIndex(lastEmittedLink, observer);
            observer.index(l);
        }

        @Override
        public NodeList.Node<Object> replayObserverFromIndex(NodeList.Node<Object> l, SubjectSubscriptionManager.SubjectObserver<? super T> observer) {
            while (l != this.tail()) {
                this.accept(observer, l.next);
                l = l.next;
            }
            return l;
        }

        @Override
        public NodeList.Node<Object> replayObserverFromIndexTest(NodeList.Node<Object> l, SubjectSubscriptionManager.SubjectObserver<? super T> observer, long now) {
            while (l != this.tail()) {
                this.acceptTest(observer, l.next, now);
                l = l.next;
            }
            return l;
        }

        @Override
        public boolean terminated() {
            return this.terminated;
        }
    }

    static final class UnboundedReplayState<T>
    implements ReplayState<T, Integer> {
        private final NotificationLite<T> nl = NotificationLite.instance();
        private final ArrayList<Object> list;
        private volatile boolean terminated;
        volatile int index;
        static final AtomicIntegerFieldUpdater<UnboundedReplayState> INDEX_UPDATER = AtomicIntegerFieldUpdater.newUpdater(UnboundedReplayState.class, "index");

        public UnboundedReplayState(int initialCapacity) {
            this.list = new ArrayList(initialCapacity);
        }

        @Override
        public void next(T n) {
            if (!this.terminated) {
                this.list.add(this.nl.next(n));
                INDEX_UPDATER.getAndIncrement(this);
            }
        }

        public void accept(Observer<? super T> o, int idx) {
            this.nl.accept(o, this.list.get(idx));
        }

        @Override
        public void complete() {
            if (!this.terminated) {
                this.terminated = true;
                this.list.add(this.nl.completed());
                INDEX_UPDATER.getAndIncrement(this);
            }
        }

        @Override
        public void error(Throwable e) {
            if (!this.terminated) {
                this.terminated = true;
                this.list.add(this.nl.error(e));
                INDEX_UPDATER.getAndIncrement(this);
            }
        }

        @Override
        public boolean terminated() {
            return this.terminated;
        }

        @Override
        public void replayObserver(SubjectSubscriptionManager.SubjectObserver<? super T> observer) {
            Integer lastEmittedLink = (Integer)observer.index();
            if (lastEmittedLink == null) {
                throw new IllegalStateException("failed to find lastEmittedLink for: " + observer);
            }
            int l = this.replayObserverFromIndex(lastEmittedLink, observer);
            observer.index(l);
        }

        @Override
        public Integer replayObserverFromIndex(Integer idx, SubjectSubscriptionManager.SubjectObserver<? super T> observer) {
            int i;
            for (i = idx.intValue(); i < this.index; ++i) {
                this.accept(observer, i);
            }
            return i;
        }

        @Override
        public Integer replayObserverFromIndexTest(Integer idx, SubjectSubscriptionManager.SubjectObserver<? super T> observer, long now) {
            return this.replayObserverFromIndex(idx, observer);
        }
    }
}

