/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Iterator;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func2;
import rx.observers.Subscribers;

public final class OperatorZipIterable<T1, T2, R>
implements Observable.Operator<R, T1> {
    final Iterable<? extends T2> iterable;
    final Func2<? super T1, ? super T2, ? extends R> zipFunction;

    public OperatorZipIterable(Iterable<? extends T2> iterable, Func2<? super T1, ? super T2, ? extends R> zipFunction) {
        this.iterable = iterable;
        this.zipFunction = zipFunction;
    }

    @Override
    public Subscriber<? super T1> call(final Subscriber<? super R> subscriber) {
        final Iterator<T2> iterator = this.iterable.iterator();
        try {
            if (!iterator.hasNext()) {
                subscriber.onCompleted();
                return Subscribers.empty();
            }
        }
        catch (Throwable e) {
            subscriber.onError(e);
        }
        return new Subscriber<T1>(subscriber){
            boolean once;

            @Override
            public void onCompleted() {
                if (this.once) {
                    return;
                }
                this.once = true;
                subscriber.onCompleted();
            }

            @Override
            public void onError(Throwable e) {
                subscriber.onError(e);
            }

            @Override
            public void onNext(T1 t) {
                try {
                    subscriber.onNext(OperatorZipIterable.this.zipFunction.call(t, iterator.next()));
                    if (!iterator.hasNext()) {
                        this.onCompleted();
                    }
                }
                catch (Throwable e) {
                    this.onError(e);
                }
            }
        };
    }
}

