/*
 * Decompiled with CFR 0.152.
 */
package io.quicksign.kafka.crypto.encryption;

import io.quicksign.kafka.crypto.Decryptor;
import io.quicksign.kafka.crypto.encryption.CryptoAlgorithm;
import io.quicksign.kafka.crypto.encryption.KeyProvider;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDecryptor
implements Decryptor {
    private static final Logger log = LoggerFactory.getLogger(DefaultDecryptor.class);
    private final KeyProvider keyProvider;
    private final CryptoAlgorithm cryptoAlgorithm;

    public DefaultDecryptor(KeyProvider keyProvider, CryptoAlgorithm cryptoAlgorithm) {
        this.keyProvider = keyProvider;
        this.cryptoAlgorithm = cryptoAlgorithm;
    }

    @Override
    public byte[] decrypt(byte[] value, byte[] keyRef) {
        Optional<byte[]> maybeKey = this.keyProvider.getKey(keyRef);
        return maybeKey.map(key -> {
            try {
                return this.cryptoAlgorithm.decrypt(value, (byte[])key);
            }
            catch (Exception e) {
                log.error("error while decrypting data", (Throwable)e);
                return null;
            }
        }).orElse(null);
    }
}

