/*
 * Decompiled with CFR 0.152.
 */
package io.qase.commons.writers;

import com.google.gson.Gson;
import io.qase.commons.QaseException;
import io.qase.commons.config.ConnectionConfig;
import io.qase.commons.config.Format;
import io.qase.commons.logger.Logger;
import io.qase.commons.models.domain.Attachment;
import io.qase.commons.models.report.ReportResult;
import io.qase.commons.models.report.Run;
import io.qase.commons.writers.Writer;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class FileWriter
implements Writer {
    private static final Logger logger = Logger.getInstance();
    private final String rootPath;
    final String resultsPath;
    final String attachmentPath;
    final Format format;

    public FileWriter(ConnectionConfig config) {
        this.format = config.local.format;
        this.rootPath = Paths.get(System.getProperty("user.dir"), config.local.path).toString();
        this.resultsPath = Paths.get(this.rootPath, "results").toString();
        this.attachmentPath = Paths.get(this.rootPath, "attachments").toString();
    }

    @Override
    public void prepare() throws QaseException {
        Path path = Paths.get(this.rootPath, new String[0]);
        this.createDirectory(path);
        Path resultsPath = Paths.get(this.resultsPath, new String[0]);
        this.createDirectory(resultsPath);
        Path attachmentPath = Paths.get(this.attachmentPath, new String[0]);
        this.createDirectory(attachmentPath);
    }

    @Override
    public void writeRun(Run run) throws QaseException {
        Gson gson = new Gson();
        String path = Paths.get(this.rootPath, "run.json").toString();
        File file = new File(path);
        try (java.io.FileWriter fileWriter = new java.io.FileWriter(file);){
            String content = gson.toJson((Object)run);
            if (this.format == Format.JSONP) {
                content = "qaseJsonp(" + content + ");";
            }
            fileWriter.write(content);
        }
        catch (IOException e) {
            throw new QaseException("Failed to write run result to file: " + path, e.getCause());
        }
    }

    @Override
    public void writeResult(ReportResult result) throws QaseException {
        Gson gson = new Gson();
        String path = Paths.get(this.resultsPath, result.id + ".json").toString();
        File file = new File(path);
        try (java.io.FileWriter fileWriter = new java.io.FileWriter(file);){
            String content = gson.toJson((Object)result);
            if (this.format == Format.JSONP) {
                content = "qaseJsonp(" + content + ");";
            }
            fileWriter.write(content);
        }
        catch (IOException e) {
            throw new QaseException("Failed to write report result to file: " + path, e.getCause());
        }
    }

    @Override
    public String writeAttachment(Attachment attachment) {
        String string;
        if (attachment.filePath != null) {
            Path source = Paths.get(attachment.filePath, new String[0]);
            Path destination = Paths.get(this.attachmentPath, attachment.id + "-" + source.getFileName().toString());
            try {
                Files.copy(source, destination, new CopyOption[0]);
                return destination.toString();
            }
            catch (IOException e) {
                logger.error("Failed to save attachment: {}", attachment.filePath, e);
                return "";
            }
        }
        String destination = Paths.get(this.attachmentPath, attachment.id + "-" + attachment.fileName).toString();
        File file = new File(destination);
        java.io.FileWriter fileWriter = new java.io.FileWriter(file);
        try {
            fileWriter.write(attachment.content);
            string = destination;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.error("Failed to write attachment content to file: {}", e.getMessage(), e);
                return "";
            }
        }
        fileWriter.close();
        return string;
    }

    private void createDirectory(Path path) throws QaseException {
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new QaseException("Failed to create directory for report: " + path, e.getCause());
            }
        }
    }
}

