/*
 * Decompiled with CFR 0.152.
 */
package io.qase.commons.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class HostInfo {
    private String execCommand(String command, String defaultValue) {
        StringBuilder output = new StringBuilder();
        try {
            String line;
            Process process = System.getProperty("os.name").toLowerCase().contains("windows") ? Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", command}) : Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command});
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                output.append(line).append("\n");
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                System.err.println("Error executing command '" + command + "': Return code " + exitCode);
                return defaultValue;
            }
            return output.toString().trim();
        }
        catch (IOException | InterruptedException e) {
            System.err.println("Exception executing command '" + command + "': " + e.getMessage());
            return defaultValue;
        }
    }

    private String getDetailedOsInfo() {
        String system = System.getProperty("os.name").toLowerCase();
        try {
            if (system.contains("windows")) {
                return this.execCommand("ver", "");
            }
            if (system.contains("mac")) {
                return this.execCommand("sw_vers -productVersion", "");
            }
            try {
                File osReleaseFile = new File("/etc/os-release");
                if (osReleaseFile.exists()) {
                    String osRelease = new String(Files.readAllBytes(Paths.get("/etc/os-release", new String[0])));
                    Pattern pattern = Pattern.compile("PRETTY_NAME=\"(.+)\"");
                    Matcher matcher = pattern.matcher(osRelease);
                    if (matcher.find()) {
                        return matcher.group(1);
                    }
                }
            }
            catch (IOException osReleaseFile) {
                // empty catch block
            }
            return System.getProperty("os.version");
        }
        catch (Exception e) {
            System.err.println("Error getting detailed OS info: " + e.getMessage());
            return System.getProperty("os.version");
        }
    }

    public Map<String, String> getHostInfo(String reporterVersion) {
        HashMap<String, String> hostInfo = new HashMap<String, String>();
        try {
            String javaVersion = System.getProperty("java.version");
            String buildToolVersion = "";
            String mavenOutput = this.execCommand("mvn --version", "");
            if (!mavenOutput.isEmpty()) {
                Pattern pattern = Pattern.compile("Apache Maven (\\S+)");
                Matcher matcher = pattern.matcher(mavenOutput);
                if (matcher.find()) {
                    buildToolVersion = matcher.group(1);
                }
            } else {
                Pattern pattern;
                Matcher matcher;
                String gradleOutput = this.execCommand("gradle --version", "");
                if (!gradleOutput.isEmpty() && (matcher = (pattern = Pattern.compile("Gradle (\\S+)")).matcher(gradleOutput)).find()) {
                    buildToolVersion = matcher.group(1);
                }
            }
            hostInfo.put("system", System.getProperty("os.name").toLowerCase());
            hostInfo.put("machineName", InetAddress.getLocalHost().getHostName());
            hostInfo.put("release", System.getProperty("os.version"));
            hostInfo.put("version", this.getDetailedOsInfo());
            hostInfo.put("arch", System.getProperty("os.arch"));
            hostInfo.put("java", javaVersion);
            hostInfo.put("buildTool", buildToolVersion);
            hostInfo.put("reporter", reporterVersion);
        }
        catch (Exception e) {
            System.err.println("Error getting host info: " + e.getMessage());
            try {
                hostInfo.put("system", System.getProperty("os.name").toLowerCase());
                hostInfo.put("machineName", InetAddress.getLocalHost().getHostName());
                hostInfo.put("release", System.getProperty("os.version"));
                hostInfo.put("version", "");
                hostInfo.put("arch", System.getProperty("os.arch"));
                hostInfo.put("java", "");
                hostInfo.put("buildTool", "");
                hostInfo.put("reporter", "");
            }
            catch (Exception ex) {
                System.err.println("Error creating fallback host info: " + ex.getMessage());
            }
        }
        return hostInfo;
    }

    public String toJson(Map<String, String> hostInfo) {
        JSONObject json = new JSONObject(hostInfo);
        return json.toString(2);
    }
}

