/*
 * Decompiled with CFR 0.152.
 */
package io.qase.commons.config;

import com.google.gson.Gson;
import io.qase.commons.config.Mode;
import io.qase.commons.config.ReportConfig;
import io.qase.commons.config.TestopsConfig;
import io.qase.commons.logger.Logger;

public class QaseConfig {
    private static final Logger logger = Logger.getInstance();
    public Mode mode = Mode.OFF;
    public Mode fallback = Mode.OFF;
    public String environment = "";
    public String rootSuite = "";
    public boolean debug = false;
    public TestopsConfig testops = new TestopsConfig();
    public ReportConfig report = new ReportConfig();

    public void setMode(String mode) {
        try {
            this.mode = Mode.valueOf(mode.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.mode = Mode.OFF;
            logger.error("Unknown mode: %s. Supported modes: %s", new Object[]{mode, Mode.values()});
        }
    }

    public void setFallback(String fallback) {
        try {
            this.fallback = Mode.valueOf(fallback.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.fallback = Mode.OFF;
            logger.error("Unknown fallback mode: %s. Supported modes: %s", new Object[]{fallback, Mode.values()});
        }
    }

    public String getMode() {
        return this.mode.toString();
    }

    public String getFallback() {
        return this.fallback.toString();
    }

    public String toString() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }
}

