/*
 * Decompiled with CFR 0.152.
 */
package io.qase.commons.aspects;

import io.qase.commons.StepStorage;
import io.qase.commons.annotation.Step;
import io.qase.commons.models.domain.StepResult;
import io.qase.commons.models.domain.StepResultStatus;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public final class StepsAspects {
    private static final String DELIMITER = ", ";

    @Pointcut(value="@annotation(io.qase.commons.annotation.Step)")
    public void withStepAnnotation() {
    }

    @Pointcut(value="execution(* *(..))")
    public void method() {
    }

    @Before(value="method() && withStepAnnotation()")
    public void stepStarting() {
        StepStorage.startStep();
    }

    @AfterReturning(pointcut="method() && withStepAnnotation()")
    public void stepFinished(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Step stepAnnotation = methodSignature.getMethod().getAnnotation(Step.class);
        String stepsTitle = stepAnnotation.value();
        stepsTitle = StepsAspects.getTitle(joinPoint, stepsTitle);
        StepResult step = StepStorage.getCurrentStep();
        step.data.action = stepsTitle;
        step.execution.status = StepResultStatus.PASSED;
        StepStorage.stopStep();
    }

    @AfterThrowing(pointcut="method() && withStepAnnotation()", throwing="e")
    public void stepFailed(JoinPoint joinPoint, Throwable e) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Step stepAnnotation = methodSignature.getMethod().getAnnotation(Step.class);
        String stepsTitle = stepAnnotation.value();
        stepsTitle = StepsAspects.getTitle(joinPoint, stepsTitle);
        StepResult step = StepStorage.getCurrentStep();
        step.data.action = stepsTitle;
        step.execution.status = StepResultStatus.FAILED;
        step.throwable = e;
        StepStorage.stopStep();
    }

    private static String getTitle(JoinPoint joinPoint, String stepsTitle) {
        String[] parameterNames = ((MethodSignature)joinPoint.getSignature()).getParameterNames();
        Object[] args = joinPoint.getArgs();
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < parameterNames.length; ++i) {
            params.put(String.format("{%s}", parameterNames[i]), StepsAspects.getString(args[i]));
        }
        for (Map.Entry entry : params.entrySet()) {
            if (!stepsTitle.contains((CharSequence)entry.getKey())) continue;
            stepsTitle = stepsTitle.replaceAll("\\" + (String)entry.getKey(), (String)entry.getValue());
        }
        return stepsTitle;
    }

    private static String getString(Object args) {
        if (args == null) {
            return "null";
        }
        if (args.getClass().isArray()) {
            if (args instanceof int[]) {
                return Arrays.toString((int[])args);
            }
            if (args instanceof long[]) {
                return Arrays.toString((long[])args);
            }
            if (args instanceof double[]) {
                return Arrays.toString((double[])args);
            }
            if (args instanceof float[]) {
                return Arrays.toString((float[])args);
            }
            if (args instanceof boolean[]) {
                return Arrays.toString((boolean[])args);
            }
            if (args instanceof short[]) {
                return Arrays.toString((short[])args);
            }
            if (args instanceof char[]) {
                return Arrays.toString((char[])args);
            }
            if (args instanceof byte[]) {
                return Arrays.toString((byte[])args);
            }
            return Arrays.stream((Object[])args).map(String::valueOf).collect(Collectors.joining(DELIMITER));
        }
        return String.valueOf(args);
    }
}

