/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import io.protostuff.compiler.model.AbstractElement;
import io.protostuff.compiler.model.SourceCodeLocation;
import io.protostuff.compiler.parser.ProtoContext;
import io.protostuff.compiler.parser.ProtoParserBaseListener;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;

public abstract class AbstractProtoParserListener
extends ProtoParserBaseListener {
    protected final ProtoContext context;
    private final BufferedTokenStream tokens;
    private BitSet usedComments;

    protected AbstractProtoParserListener(BufferedTokenStream tokens, ProtoContext context) {
        this.context = context;
        this.tokens = tokens;
        this.usedComments = new BitSet();
    }

    protected SourceCodeLocation getSourceCodeLocation(ParserRuleContext ctx) {
        String file = this.context.getProto().getFilename();
        int line = ctx.getStart().getLine();
        return new SourceCodeLocation(file, line);
    }

    protected void attachComments(ParserRuleContext ctx, AbstractElement element, boolean addTrailingComment) {
        ArrayList<String> comments = new ArrayList<String>();
        Token stop = ctx.getStop();
        Token start = ctx.getStart();
        List tokensBefore = this.tokens.getHiddenTokensToLeft(start.getTokenIndex(), 1);
        if (tokensBefore != null) {
            for (Token token2 : tokensBefore) {
                if (this.usedComments.get(token2.getLine()) || token2.getType() != 40) continue;
                this.addCommentToList(token2, comments);
            }
        }
        if (addTrailingComment) {
            List tokensAfter = this.tokens.getHiddenTokensToRight(stop.getTokenIndex(), 1);
            this.findTrailingComment(tokensAfter).ifPresent(token -> this.addCommentToList((Token)token, (List<String>)comments));
        }
        List<String> trimComments = this.trim(comments);
        for (String comment : trimComments) {
            element.addComment(comment);
        }
    }

    private void addCommentToList(Token token, List<String> comments) {
        String text = this.getTextFromLineCommentToken(token);
        comments.add(text);
        this.usedComments.set(token.getLine());
    }

    private Optional<Token> findTrailingComment(@Nullable List<Token> tokensAfter) {
        if (tokensAfter == null) {
            return Optional.empty();
        }
        Optional<Token> trailingComment = Optional.empty();
        for (Token token : tokensAfter) {
            if (token.getType() == 40) {
                trailingComment = Optional.of(token);
            }
            if (!trailingComment.isPresent() && token.getType() != 41) continue;
            break;
        }
        return trailingComment;
    }

    protected List<String> trim(List<String> comments) {
        ArrayList<String> trimComments = new ArrayList<String>();
        int n = 0;
        boolean tryRemoveWhitespace = true;
        while (tryRemoveWhitespace) {
            boolean allLinesAreShorter = true;
            for (String comment : comments) {
                if (comment.length() <= n) continue;
                if (comment.charAt(n) != ' ') {
                    tryRemoveWhitespace = false;
                }
                allLinesAreShorter = false;
            }
            if (allLinesAreShorter) break;
            if (!tryRemoveWhitespace) continue;
            ++n;
        }
        for (String comment : comments) {
            if (comment.length() > n) {
                String substring = comment.substring(n);
                trimComments.add(substring);
                continue;
            }
            trimComments.add("");
        }
        return trimComments;
    }

    protected String getTextFromLineCommentToken(Token token) {
        String comment = token.getText().trim();
        return comment.substring(2);
    }
}

