/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import com.google.common.annotations.VisibleForTesting;
import io.protostuff.compiler.model.DynamicMessage;
import io.protostuff.compiler.model.Enum;
import io.protostuff.compiler.model.EnumConstant;
import io.protostuff.compiler.model.Field;
import io.protostuff.compiler.model.Message;
import io.protostuff.compiler.model.Range;
import io.protostuff.compiler.model.Service;
import io.protostuff.compiler.model.ServiceMethod;
import io.protostuff.compiler.parser.ParserException;
import io.protostuff.compiler.parser.ProtoContext;
import io.protostuff.compiler.parser.ProtoContextPostProcessor;
import io.protostuff.compiler.parser.ProtoWalker;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class UserTypeValidationPostProcessor
implements ProtoContextPostProcessor {
    private static final String ALLOW_ALIAS = "allow_alias";
    private static final int MIN_TAG = 1;
    private static final int MAX_TAG = 0x1FFFFFFF;
    private static final int SYS_RESERVED_START = 19000;
    private static final int SYS_RESERVED_END = 19999;

    @Override
    public void process(ProtoContext context) {
        ProtoWalker.newInstance(context).onMessage(this::processMessage).onEnum(this::processEnum).onService(this::processService).walk();
    }

    private void processService(Service service) {
        List<ServiceMethod> methods = service.getMethods();
        this.checkDuplicateServiceMethodNames(methods);
    }

    private void checkDuplicateServiceMethodNames(List<ServiceMethod> methods) {
        HashMap<String, ServiceMethod> methodsByName = new HashMap<String, ServiceMethod>();
        for (ServiceMethod method : methods) {
            String name = method.getName();
            if (methodsByName.containsKey(name)) {
                throw new ParserException(method, "Duplicate service method name: '%s'", name);
            }
            methodsByName.put(name, method);
        }
    }

    private void processEnum(Enum anEnum) {
        List<EnumConstant> constants = anEnum.getConstants();
        this.checkDuplicateEnumConstantNames(constants);
        this.checkDuplicateEnumConstantValues(anEnum, constants);
    }

    private void checkDuplicateEnumConstantValues(Enum anEnum, List<EnumConstant> constants) {
        DynamicMessage.Value allowAlias = anEnum.getOptions().get(ALLOW_ALIAS);
        if (allowAlias != null && allowAlias.isBooleanType() && allowAlias.getBoolean()) {
            return;
        }
        HashMap<Integer, EnumConstant> constantByValue = new HashMap<Integer, EnumConstant>();
        for (EnumConstant constant : constants) {
            Integer value = constant.getValue();
            if (constantByValue.containsKey(value)) {
                throw new ParserException(constant, "Duplicate enum constant value: %d", value);
            }
            constantByValue.put(value, constant);
        }
    }

    private void checkDuplicateEnumConstantNames(List<EnumConstant> constants) {
        HashMap<String, EnumConstant> constantByName = new HashMap<String, EnumConstant>();
        for (EnumConstant constant : constants) {
            String name = constant.getName();
            if (constantByName.containsKey(name)) {
                throw new ParserException(constant, "Duplicate enum constant name: '%s'", name);
            }
            constantByName.put(name, constant);
        }
    }

    private void processMessage(Message message) {
        List<Field> fields = message.getFields();
        this.checkInvalidFieldTags(fields);
        this.checkDuplicateFieldTags(fields);
        this.checkDuplicateFieldNames(fields);
        this.checkReservedFieldTags(message, fields);
        this.checkReservedFieldNames(message, fields);
    }

    private void checkReservedFieldTags(Message message, List<Field> fields) {
        List<Range> ranges = message.getReservedFieldRanges();
        for (Field field : fields) {
            int tag = field.getTag();
            for (Range range : ranges) {
                if (!range.contains(tag)) continue;
                throw new ParserException(field, "Reserved field tag: %d", tag);
            }
        }
    }

    private void checkReservedFieldNames(Message message, List<Field> fields) {
        HashSet<String> names = new HashSet<String>(message.getReservedFieldNames());
        for (Field field : fields) {
            String name = field.getName();
            if (!names.contains(name)) continue;
            throw new ParserException(field, "Reserved field name: '%s'", name);
        }
    }

    private void checkInvalidFieldTags(List<Field> fields) {
        for (Field field : fields) {
            int tag = field.getTag();
            if (this.isValidTagValue(tag)) continue;
            throw new ParserException(field, "Invalid tag: %d, allowed range is [%d, %d) and (%d, %d]", tag, 1, 19000, 19999, 0x1FFFFFFF);
        }
    }

    @VisibleForTesting
    boolean isValidTagValue(int tag) {
        return tag >= 1 && tag <= 0x1FFFFFFF && (tag < 19000 || tag > 19999);
    }

    private void checkDuplicateFieldTags(List<Field> fields) {
        HashMap<Integer, Field> fieldByTag = new HashMap<Integer, Field>();
        for (Field field : fields) {
            int tag = field.getTag();
            if (fieldByTag.containsKey(tag)) {
                throw new ParserException(field, "Duplicate field tag: %d", tag);
            }
            fieldByTag.put(tag, field);
        }
    }

    private void checkDuplicateFieldNames(List<Field> fields) {
        HashMap<String, Field> fieldByName = new HashMap<String, Field>();
        for (Field field : fields) {
            String name = field.getName();
            if (fieldByName.containsKey(name)) {
                throw new ParserException(field, "Duplicate field name: '%s'", name);
            }
            fieldByName.put(name, field);
        }
    }
}

