/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import io.protostuff.compiler.model.Import;
import io.protostuff.compiler.model.Package;
import io.protostuff.compiler.model.Proto;
import io.protostuff.compiler.model.Syntax;
import io.protostuff.compiler.parser.AbstractProtoParserListener;
import io.protostuff.compiler.parser.ProtoContext;
import io.protostuff.compiler.parser.ProtoParser;
import io.protostuff.compiler.parser.Util;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.Token;

public class ProtoParseListener
extends AbstractProtoParserListener {
    private final BufferedTokenStream tokens;

    ProtoParseListener(BufferedTokenStream tokens, ProtoContext context) {
        super(tokens, context);
        this.tokens = tokens;
    }

    @Override
    public void exitProto(ProtoParser.ProtoContext ctx) {
        Token token;
        int i;
        ArrayList<String> comments = new ArrayList<String>();
        for (i = 0; i < this.tokens.size() && this.isWhitespace(this.tokens.get(i)); ++i) {
        }
        while (i < this.tokens.size() && this.isComment(this.tokens.get(i))) {
            token = this.tokens.get(i);
            i += 2;
            String text = this.getTextFromLineCommentToken(token);
            comments.add(text);
        }
        if (i < this.tokens.size() && this.isCommentBlockOwner(token = this.tokens.get(i))) {
            return;
        }
        List<String> trimComments = this.trim(comments);
        for (String comment : trimComments) {
            this.context.getProto().addComment(comment);
        }
    }

    private boolean isComment(Token token) {
        return token.getChannel() == 1 && token.getType() == 40;
    }

    private boolean isWhitespace(Token token) {
        return token.getChannel() == 1 && token.getType() != 40;
    }

    private boolean isCommentBlockOwner(Token token) {
        int type = token.getType();
        return type == 6 || type == 17 || type == 18;
    }

    @Override
    public void exitSyntax(ProtoParser.SyntaxContext ctx) {
        Proto proto = this.context.peek(Proto.class);
        String text = ctx.STRING_VALUE().getText();
        String value = Util.removeFirstAndLastChar(text);
        Syntax syntax = new Syntax(proto, value);
        syntax.setSourceCodeLocation(this.getSourceCodeLocation(ctx));
        proto.setSyntax(syntax);
    }

    @Override
    public void exitPackageStatement(ProtoParser.PackageStatementContext ctx) {
        Proto proto = this.context.peek(Proto.class);
        String packageName = ctx.packageName().getText();
        Package aPackage = new Package(proto, packageName);
        aPackage.setSourceCodeLocation(this.getSourceCodeLocation(ctx));
        proto.setPackage(aPackage);
    }

    @Override
    public void exitImportStatement(ProtoParser.ImportStatementContext ctx) {
        Proto proto = this.context.peek(Proto.class);
        String text = ctx.fileReference().getText();
        String fileName = Util.removeFirstAndLastChar(text);
        Import anImport = new Import(proto, fileName, ctx.PUBLIC() != null);
        anImport.setSourceCodeLocation(this.getSourceCodeLocation(ctx));
        proto.addImport(anImport);
    }
}

