package io.protostuff.compiler.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link Module}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableModule.builder()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "Module"})
@Immutable
@CheckReturnValue
public final class ImmutableModule implements Module {
  private final String name;
  private final ImmutableList<Proto> protos;
  private final String output;
  private final ImmutableMap<String, Object> options;
  private final UsageIndex usageIndex;

  private ImmutableModule(
      String name,
      ImmutableList<Proto> protos,
      String output,
      ImmutableMap<String, Object> options,
      UsageIndex usageIndex) {
    this.name = name;
    this.protos = protos;
    this.output = output;
    this.options = options;
    this.usageIndex = usageIndex;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code protos} attribute
   */
  @Override
  public ImmutableList<Proto> getProtos() {
    return protos;
  }

  /**
   * @return The value of the {@code output} attribute
   */
  @Override
  public String getOutput() {
    return output;
  }

  /**
   * @return The value of the {@code options} attribute
   */
  @Override
  public ImmutableMap<String, Object> getOptions() {
    return options;
  }

  /**
   * @return The value of the {@code usageIndex} attribute
   */
  @Override
  public UsageIndex usageIndex() {
    return usageIndex;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Module#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableModule withName(String value) {
    if (this.name.equals(value)) return this;
    String newValue = Preconditions.checkNotNull(value, "name");
    return new ImmutableModule(newValue, this.protos, this.output, this.options, this.usageIndex);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Module#getProtos() protos}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableModule withProtos(Proto... elements) {
    ImmutableList<Proto> newValue = ImmutableList.copyOf(elements);
    return new ImmutableModule(this.name, newValue, this.output, this.options, this.usageIndex);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Module#getProtos() protos}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of protos elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableModule withProtos(Iterable<? extends Proto> elements) {
    if (this.protos == elements) return this;
    ImmutableList<Proto> newValue = ImmutableList.copyOf(elements);
    return new ImmutableModule(this.name, newValue, this.output, this.options, this.usageIndex);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Module#getOutput() output} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for output
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableModule withOutput(String value) {
    if (this.output.equals(value)) return this;
    String newValue = Preconditions.checkNotNull(value, "output");
    return new ImmutableModule(this.name, this.protos, newValue, this.options, this.usageIndex);
  }

  /**
   * Copy the current immutable object by replacing the {@link Module#getOptions() options} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the options map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableModule withOptions(Map<String, ? extends Object> entries) {
    if (this.options == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableModule(this.name, this.protos, this.output, newValue, this.usageIndex);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Module#usageIndex() usageIndex} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for usageIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableModule withUsageIndex(UsageIndex value) {
    if (this.usageIndex == value) return this;
    UsageIndex newValue = Preconditions.checkNotNull(value, "usageIndex");
    return new ImmutableModule(this.name, this.protos, this.output, this.options, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableModule} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableModule
        && equalTo((ImmutableModule) another);
  }

  private boolean equalTo(ImmutableModule another) {
    return name.equals(another.name)
        && protos.equals(another.protos)
        && output.equals(another.output)
        && options.equals(another.options)
        && usageIndex.equals(another.usageIndex);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code protos}, {@code output}, {@code options}, {@code usageIndex}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + protos.hashCode();
    h += (h << 5) + output.hashCode();
    h += (h << 5) + options.hashCode();
    h += (h << 5) + usageIndex.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Module} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Module")
        .omitNullValues()
        .add("name", name)
        .add("protos", protos)
        .add("output", output)
        .add("options", options)
        .add("usageIndex", usageIndex)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Module} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Module instance
   */
  public static ImmutableModule copyOf(Module instance) {
    if (instance instanceof ImmutableModule) {
      return (ImmutableModule) instance;
    }
    return ImmutableModule.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableModule ImmutableModule}.
   * @return A new ImmutableModule builder
   */
  public static ImmutableModule.Builder builder() {
    return new ImmutableModule.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableModule ImmutableModule}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_OUTPUT = 0x2L;
    private static final long INIT_BIT_USAGE_INDEX = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String name;
    private ImmutableList.Builder<Proto> protos = ImmutableList.builder();
    private @Nullable String output;
    private ImmutableMap.Builder<String, Object> options = ImmutableMap.builder();
    private @Nullable UsageIndex usageIndex;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Module} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Module instance) {
      Preconditions.checkNotNull(instance, "instance");
      name(instance.getName());
      addAllProtos(instance.getProtos());
      output(instance.getOutput());
      putAllOptions(instance.getOptions());
      usageIndex(instance.usageIndex());
      return this;
    }

    /**
     * Initializes the value for the {@link Module#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Adds one element to {@link Module#getProtos() protos} list.
     * @param element A protos element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addProtos(Proto element) {
      this.protos.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Module#getProtos() protos} list.
     * @param elements An array of protos elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addProtos(Proto... elements) {
      this.protos.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link Module#getProtos() protos} list.
     * @param elements An iterable of protos elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder protos(Iterable<? extends Proto> elements) {
      this.protos = ImmutableList.builder();
      return addAllProtos(elements);
    }

    /**
     * Adds elements to {@link Module#getProtos() protos} list.
     * @param elements An iterable of protos elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllProtos(Iterable<? extends Proto> elements) {
      this.protos.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link Module#getOutput() output} attribute.
     * @param output The value for output 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder output(String output) {
      this.output = Preconditions.checkNotNull(output, "output");
      initBits &= ~INIT_BIT_OUTPUT;
      return this;
    }

    /**
     * Put one entry to the {@link Module#getOptions() options} map.
     * @param key The key in the options map
     * @param value The associated value in the options map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putOptions(String key, Object value) {
      this.options.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Module#getOptions() options} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putOptions(Map.Entry<String, ? extends Object> entry) {
      this.options.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Module#getOptions() options} map. Nulls are not permitted
     * @param options The entries that will be added to the options map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder options(Map<String, ? extends Object> options) {
      this.options = ImmutableMap.builder();
      return putAllOptions(options);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Module#getOptions() options} map. Nulls are not permitted
     * @param options The entries that will be added to the options map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllOptions(Map<String, ? extends Object> options) {
      this.options.putAll(options);
      return this;
    }

    /**
     * Initializes the value for the {@link Module#usageIndex() usageIndex} attribute.
     * @param usageIndex The value for usageIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder usageIndex(UsageIndex usageIndex) {
      this.usageIndex = Preconditions.checkNotNull(usageIndex, "usageIndex");
      initBits &= ~INIT_BIT_USAGE_INDEX;
      return this;
    }

    /**
     * Builds a new {@link ImmutableModule ImmutableModule}.
     * @return An immutable instance of Module
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableModule build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableModule(name, protos.build(), output, options.build(), usageIndex);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_OUTPUT) != 0) attributes.add("output");
      if ((initBits & INIT_BIT_USAGE_INDEX) != 0) attributes.add("usageIndex");
      return "Cannot build Module, some of required attributes are not set " + attributes;
    }
  }
}
