/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import com.google.common.base.Preconditions;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Util {
    public static final char WINDOWS_DELIMITER = '\\';
    public static final char LINUX_DELIMITER = '/';
    public static final char QUOTE = '\"';

    public static String removeFirstAndLastChar(String text) {
        Preconditions.checkNotNull((Object)text, (Object)"text can not be null");
        int n = text.length();
        return text.substring(1, n - 1);
    }

    public static String getFileName(String fullPath) {
        Preconditions.checkNotNull((Object)fullPath, (Object)"path can not be null");
        int winDelimiterPos = fullPath.lastIndexOf(92);
        int linDelimiterPos = fullPath.lastIndexOf(47);
        int pos = Math.max(winDelimiterPos, linDelimiterPos);
        return fullPath.substring(pos + 1, fullPath.length());
    }
}

