/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import io.protostuff.compiler.model.Element;
import io.protostuff.compiler.model.Proto;
import io.protostuff.compiler.model.Type;
import io.protostuff.compiler.parser.ExtensionRegistry;
import io.protostuff.compiler.parser.FileReader;
import io.protostuff.compiler.parser.ParserException;
import io.protostuff.compiler.parser.ProtoExtensionRegistry;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtoContext.class);
    private final String filename;
    private final Map<String, Type> symbolTable;
    private final Deque<Object> declarationStack;
    private final Proto proto;
    private final ExtensionRegistry extensionRegistry;
    private final List<ProtoContext> imports;
    private final List<ProtoContext> publicImports;
    private boolean initialized;
    private FileReader fileReader;

    public ProtoContext(String filename) {
        this.filename = filename;
        this.symbolTable = new HashMap<String, Type>();
        this.declarationStack = new ArrayDeque<Object>();
        this.imports = new ArrayList<ProtoContext>();
        this.publicImports = new ArrayList<ProtoContext>();
        this.proto = new Proto();
        this.proto.setContext(this);
        this.proto.setFilename(filename);
        this.proto.setName(this.getFilenameWithoutExtension(filename));
        this.push(this.proto);
        this.extensionRegistry = new ProtoExtensionRegistry(this);
    }

    private String getFilenameWithoutExtension(String filename) {
        String shortFilename = FilenameUtils.getName((String)filename);
        return FilenameUtils.removeExtension((String)shortFilename);
    }

    public <T> T peek(Class<T> declarationClass) {
        Object declaration = this.declarationStack.peek();
        if (declaration == null) {
            throw new IllegalStateException("Declaration stack is empty");
        }
        if (declarationClass.isAssignableFrom(declaration.getClass())) {
            return (T)declaration;
        }
        return this.fail(declaration, declarationClass);
    }

    public void push(Object declaration) {
        this.declarationStack.push(declaration);
    }

    public <T> T pop(Class<T> declarationClass) {
        Object declaration = this.declarationStack.pop();
        if (declarationClass.isAssignableFrom(declaration.getClass())) {
            return (T)declaration;
        }
        return this.fail(declaration, declarationClass);
    }

    public <T extends Type & Element> void register(String fullyQualifiedName, T type) {
        if (this.resolve(fullyQualifiedName) != null) {
            throw new ParserException(type, "Cannot register duplicate type: %s", fullyQualifiedName);
        }
        this.symbolTable.put(fullyQualifiedName, type);
    }

    private <T> T fail(Object descriptor, Class<T> targetClass) {
        String source = descriptor.getClass().getSimpleName();
        String target = targetClass.getSimpleName();
        String message = String.format("Can not cast %s to %s", source, target);
        throw new IllegalStateException(message);
    }

    public Proto getProto() {
        return this.proto;
    }

    public <T extends Type> T resolve(String typeName, Class<T> clazz) {
        Type instance = this.resolve(typeName);
        if (instance == null) {
            return null;
        }
        if (clazz.isAssignableFrom(instance.getClass())) {
            return (T)((Type)clazz.cast(instance));
        }
        throw new ParserException("Type error: %s of type %s can not be cast to %s", typeName, instance.getClass(), clazz);
    }

    public <T extends Type> T resolve(Class<T> typeClass, String fullyQualifiedName) {
        Type result = this.resolve(fullyQualifiedName);
        if (result == null) {
            return null;
        }
        if (typeClass.isAssignableFrom(result.getClass())) {
            return (T)result;
        }
        throw new ClassCastException(result.getClass() + " cannot be cast to " + typeClass);
    }

    public Type resolve(String fullyQualifiedName) {
        Type imported;
        Type local = this.symbolTable.get(fullyQualifiedName);
        if (local != null) {
            return local;
        }
        for (ProtoContext importedContext : this.publicImports) {
            imported = importedContext.resolve(fullyQualifiedName);
            if (imported == null) continue;
            return imported;
        }
        for (ProtoContext importedContext : this.imports) {
            imported = importedContext.resolveImport(fullyQualifiedName);
            if (imported == null) continue;
            return imported;
        }
        return null;
    }

    public Type resolveImport(String typeName) {
        Type local = this.symbolTable.get(typeName);
        if (local != null) {
            return local;
        }
        for (ProtoContext importedContext : this.publicImports) {
            Type imported = importedContext.resolveImport(typeName);
            if (imported == null) continue;
            return imported;
        }
        return null;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public List<ProtoContext> getImports() {
        return this.imports;
    }

    public void addImport(ProtoContext importedProto) {
        this.imports.add(importedProto);
    }

    public List<ProtoContext> getPublicImports() {
        return this.publicImports;
    }

    public void addPublicImport(ProtoContext importedProto) {
        this.publicImports.add(importedProto);
    }

    public ExtensionRegistry getExtensionRegistry() {
        return this.extensionRegistry;
    }

    public FileReader getFileReader() {
        return this.fileReader;
    }

    public void setFileReader(FileReader fileReader) {
        this.fileReader = fileReader;
    }

    public String toString() {
        return "ProtoContext{'" + this.filename + "'}";
    }
}

