/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import io.protostuff.compiler.model.AbstractDescriptor;
import io.protostuff.compiler.model.DynamicMessage;
import io.protostuff.compiler.model.SourceCodeLocation;
import io.protostuff.compiler.parser.AbstractProtoParserListener;
import io.protostuff.compiler.parser.ProtoContext;
import io.protostuff.compiler.parser.ProtoParser;
import io.protostuff.compiler.parser.Util;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Deque;
import org.antlr.v4.runtime.BufferedTokenStream;

public class OptionParseListener
extends AbstractProtoParserListener {
    public static final int HEX = 16;
    public static final int OCT = 8;
    public static final int DECIMAL = 10;
    private final Deque<DynamicMessage> textFormatStack = new ArrayDeque<DynamicMessage>();
    private DynamicMessage currentTextFormat;
    private DynamicMessage lastTextFormat;

    protected OptionParseListener(BufferedTokenStream tokens, ProtoContext context) {
        super(tokens, context);
    }

    @Override
    public void exitOption(ProtoParser.OptionContext ctx) {
        AbstractDescriptor declaration = this.context.peek(AbstractDescriptor.class);
        ProtoParser.OptionValueContext optionValueContext = ctx.optionValue();
        String optionName = ctx.optionName().getText();
        DynamicMessage.Value optionValue = this.getOptionValue(optionValueContext);
        SourceCodeLocation sourceCodeLocation = this.getSourceCodeLocation(optionValueContext);
        declaration.getOptions().set(sourceCodeLocation, optionName, optionValue);
    }

    private DynamicMessage.Value getOptionValue(ProtoParser.OptionValueContext optionValueContext) {
        DynamicMessage.Value optionValue;
        SourceCodeLocation sourceCodeLocation = this.getSourceCodeLocation(optionValueContext);
        if (optionValueContext.textFormat() != null) {
            optionValue = DynamicMessage.Value.createMessage(sourceCodeLocation, this.lastTextFormat);
        } else if (optionValueContext.BOOLEAN_VALUE() != null) {
            String text = optionValueContext.BOOLEAN_VALUE().getText();
            boolean value = Boolean.parseBoolean(text);
            optionValue = DynamicMessage.Value.createBoolean(sourceCodeLocation, value);
        } else if (optionValueContext.INTEGER_VALUE() != null) {
            String text = optionValueContext.INTEGER_VALUE().getText();
            optionValue = this.parseInteger(sourceCodeLocation, text);
        } else if (optionValueContext.STRING_VALUE() != null) {
            String text = optionValueContext.STRING_VALUE().getText();
            optionValue = DynamicMessage.Value.createString(sourceCodeLocation, Util.removeFirstAndLastChar(text));
        } else if (optionValueContext.IDENT() != null) {
            String text = optionValueContext.IDENT().getText();
            optionValue = DynamicMessage.Value.createEnum(sourceCodeLocation, text);
        } else if (optionValueContext.FLOAT_VALUE() != null) {
            String text = optionValueContext.FLOAT_VALUE().getText();
            double value = "inf".equals(text) ? Double.POSITIVE_INFINITY : ("-inf".equals(text) ? Double.NEGATIVE_INFINITY : Double.parseDouble(text));
            optionValue = DynamicMessage.Value.createFloat(sourceCodeLocation, value);
        } else {
            throw new IllegalStateException();
        }
        return optionValue;
    }

    private DynamicMessage.Value parseInteger(SourceCodeLocation sourceCodeLocation, String text) {
        long value;
        try {
            value = Long.decode(text);
        }
        catch (NumberFormatException e) {
            if (text.startsWith("0x")) {
                BigInteger num = new BigInteger(text.substring(2), 16);
                value = num.longValue();
            }
            if (text.startsWith("0")) {
                BigInteger num = new BigInteger(text.substring(1), 8);
                value = num.longValue();
            }
            BigInteger num = new BigInteger(text, 10);
            value = num.longValue();
        }
        return DynamicMessage.Value.createInteger(sourceCodeLocation, value);
    }

    @Override
    public void enterTextFormat(ProtoParser.TextFormatContext ctx) {
        if (this.currentTextFormat != null) {
            this.textFormatStack.push(this.currentTextFormat);
        }
        this.currentTextFormat = new DynamicMessage();
    }

    @Override
    public void exitTextFormat(ProtoParser.TextFormatContext ctx) {
        this.lastTextFormat = this.currentTextFormat;
        this.currentTextFormat = this.textFormatStack.peek() != null ? this.textFormatStack.pop() : null;
    }

    @Override
    public void exitTextFormatEntry(ProtoParser.TextFormatEntryContext ctx) {
        String optionName = ctx.textFormatOptionName().ident() != null ? ctx.textFormatOptionName().getText() : "(" + ctx.textFormatOptionName().typeReference().getText() + ")";
        DynamicMessage.Value value = this.getTextFormatOptionValue(ctx);
        this.currentTextFormat.set(this.getSourceCodeLocation(ctx), optionName, value);
    }

    private DynamicMessage.Value getTextFormatOptionValue(ProtoParser.TextFormatEntryContext ctx) {
        DynamicMessage.Value optionValue;
        SourceCodeLocation sourceCodeLocation = this.getSourceCodeLocation(ctx);
        if (ctx.textFormat() != null) {
            optionValue = DynamicMessage.Value.createMessage(sourceCodeLocation, this.lastTextFormat);
        } else if (ctx.textFormatOptionValue().BOOLEAN_VALUE() != null) {
            String text = ctx.textFormatOptionValue().BOOLEAN_VALUE().getText();
            boolean value = Boolean.parseBoolean(text);
            optionValue = DynamicMessage.Value.createBoolean(sourceCodeLocation, value);
        } else if (ctx.textFormatOptionValue().INTEGER_VALUE() != null) {
            String text = ctx.textFormatOptionValue().INTEGER_VALUE().getText();
            optionValue = this.parseInteger(sourceCodeLocation, text);
        } else if (ctx.textFormatOptionValue().STRING_VALUE() != null) {
            String text = ctx.textFormatOptionValue().STRING_VALUE().getText();
            optionValue = DynamicMessage.Value.createString(sourceCodeLocation, Util.removeFirstAndLastChar(text));
        } else if (ctx.textFormatOptionValue().IDENT() != null) {
            String text = ctx.textFormatOptionValue().IDENT().getText();
            optionValue = DynamicMessage.Value.createEnum(sourceCodeLocation, text);
        } else if (ctx.textFormatOptionValue().FLOAT_VALUE() != null) {
            String text = ctx.textFormatOptionValue().FLOAT_VALUE().getText();
            double value = Double.parseDouble(text);
            optionValue = DynamicMessage.Value.createFloat(sourceCodeLocation, value);
        } else {
            throw new IllegalStateException();
        }
        return optionValue;
    }
}

