/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.AbstractInvocationHandler;
import com.google.common.reflect.Reflection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.annotation.ParametersAreNonnullByDefault;
import org.antlr.v4.runtime.tree.ParseTreeListener;

public class CompositeParseTreeListener {
    @SafeVarargs
    public static <T extends ParseTreeListener> T create(Class<T> type, T ... delegates) {
        final ImmutableList listeners = ImmutableList.copyOf((Object[])delegates);
        return (T)((ParseTreeListener)Reflection.newProxy(type, (InvocationHandler)new AbstractInvocationHandler(){

            @ParametersAreNonnullByDefault
            protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
                for (ParseTreeListener listener : listeners) {
                    method.invoke((Object)listener, args);
                }
                return null;
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"CompositeParseTreeListener").add("listeners", (Object)listeners).toString();
            }
        }));
    }
}

