/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.model;

import com.google.common.base.MoreObjects;
import io.protostuff.compiler.model.AbstractDescriptor;
import io.protostuff.compiler.model.DescriptorType;
import io.protostuff.compiler.model.DynamicMessage;
import io.protostuff.compiler.model.FieldContainer;
import io.protostuff.compiler.model.FieldModifier;
import io.protostuff.compiler.model.FieldType;
import io.protostuff.compiler.model.Message;
import io.protostuff.compiler.model.Oneof;

public class Field
extends AbstractDescriptor {
    public static final int MAX_TAG_VALUE = 0x1FFFFFFF;
    public static final DynamicMessage.Value DV_TRUE = DynamicMessage.Value.createBoolean(true);
    protected FieldModifier modifier;
    protected String typeName;
    protected FieldType type;
    protected int tag;
    protected int index;
    private FieldContainer parent;
    private Oneof oneof;

    public Field(FieldContainer parent) {
        this.parent = parent;
    }

    @Override
    public FieldContainer getParent() {
        return this.parent;
    }

    public void setParent(Message parent) {
        this.parent = parent;
    }

    public FieldModifier getModifier() {
        return this.modifier == null ? FieldModifier.DEFAULT : this.modifier;
    }

    public void setModifier(FieldModifier modifier) {
        this.modifier = modifier;
    }

    public boolean hasModifier() {
        return this.modifier != null;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public int getTag() {
        return this.tag;
    }

    public void setTag(int tag) {
        this.tag = tag;
    }

    public FieldType getType() {
        return this.type;
    }

    public void setType(FieldType type) {
        this.type = type;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Oneof getOneof() {
        return this.oneof;
    }

    public void setOneof(Oneof oneof) {
        this.oneof = oneof;
    }

    public boolean isOneofPart() {
        return this.oneof != null;
    }

    public boolean isRepeated() {
        return this.getModifier() == FieldModifier.REPEATED;
    }

    public boolean isMap() {
        if (this.type instanceof Message) {
            Message message = (Message)this.type;
            return message.isMapEntry();
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("modifier", (Object)this.modifier).add("typeName", (Object)this.typeName).add("tag", this.tag).add("options", (Object)this.options).toString();
    }

    @Override
    public DescriptorType getDescriptorType() {
        return DescriptorType.MESSAGE_FIELD;
    }
}

