/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.protostuff.compiler.model.AbstractElement;
import io.protostuff.compiler.model.Element;
import io.protostuff.compiler.model.SourceCodeLocation;
import io.protostuff.compiler.parser.ParserException;
import io.protostuff.compiler.parser.Util;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class DynamicMessage
implements Map<String, Value> {
    public static final char LPAREN = '(';
    public static final char RPAREN = ')';
    public static final char DOT = '.';
    private final Map<Key, Value> fields = new HashMap<Key, Value>();

    public Value get(String name) {
        if (name.length() > 1) {
            int dot;
            if (name.charAt(0) == '(') {
                int start = name.indexOf(41);
                dot = name.indexOf(46, start);
            } else {
                dot = name.indexOf(46);
            }
            if (dot > 0) {
                String fieldName = name.substring(0, dot);
                String rest = name.substring(dot + 1);
                Key key = this.createKey(fieldName);
                Value value = this.fields.get(key);
                if (!value.isMessageType()) {
                    throw new ParserException("Invalid option name: %s", name);
                }
                DynamicMessage msg = value.getMessage();
                return msg.get(rest);
            }
            Key key = this.createKey(name);
            return this.fields.get(key);
        }
        Key key = Key.field(name);
        return this.fields.get(key);
    }

    public void set(String name, Value value) {
        this.set(SourceCodeLocation.UNKNOWN, name, value);
    }

    public void set(SourceCodeLocation sourceCodeLocation, String name, Value value) {
        if (name.length() > 1) {
            int dot;
            if (name.charAt(0) == '(') {
                int start = name.indexOf(41);
                dot = name.indexOf(46, start);
            } else {
                dot = name.indexOf(46);
            }
            if (dot > 0) {
                DynamicMessage msg;
                String fieldName = name.substring(0, dot);
                String rest = name.substring(dot + 1);
                Key key = this.createKey(fieldName);
                if (this.fields.containsKey(key)) {
                    Value val = this.fields.get(key);
                    if (!val.isMessageType()) {
                        throw new ParserException(value, "Can not assign option value: type error", new Object[0]);
                    }
                    msg = val.getMessage();
                } else {
                    msg = new DynamicMessage();
                    this.fields.put(key, Value.createMessage(sourceCodeLocation, msg));
                }
                msg.set(sourceCodeLocation, rest, value);
            } else {
                Key key = this.createKey(name);
                this.set(key, value);
            }
        } else {
            Key key = Key.field(name);
            this.set(key, value);
        }
    }

    private void set(Key key, Value value) {
        if (this.fields.containsKey(key) && value.isMessageType()) {
            Value prevValue = this.fields.get(key);
            if (!prevValue.isMessageType()) {
                throw new ParserException(value, "Can not set '%s': incompatible type", key);
            }
            DynamicMessage prevMessage = prevValue.getMessage();
            DynamicMessage message = value.getMessage();
            prevMessage.merge(message);
        } else {
            this.fields.put(key, value);
        }
    }

    private void merge(DynamicMessage message) {
        for (Map.Entry<Key, Value> entry : message.fields.entrySet()) {
            Key key = entry.getKey();
            Value value = entry.getValue();
            this.set(key, value);
        }
    }

    private Key createKey(String fieldName) {
        Key key;
        if (fieldName.startsWith("(")) {
            String name = Util.removeFirstAndLastChar(fieldName);
            key = Key.extension(name);
        } else {
            key = Key.field(fieldName);
        }
        return key;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fields", this.fields).toString();
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    @Override
    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            String name = (String)key;
            return this.get(name) != null;
        }
        return this.fields.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.fields.containsValue(value);
    }

    @Override
    public Value get(Object key) {
        if (key instanceof String) {
            String name = (String)key;
            return this.get(name);
        }
        return this.fields.get(key);
    }

    @Override
    public Value put(String key, Value value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@Nonnull Map<? extends String, ? extends Value> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Set<String> keySet() {
        Set<Key> keys = this.fields.keySet();
        return keys.stream().map(Key::toString).collect(Collectors.toSet());
    }

    @Override
    @Nonnull
    public Collection<Value> values() {
        return this.fields.values();
    }

    @Override
    @Nonnull
    public Set<Map.Entry<String, Value>> entrySet() {
        HashMap<String, Value> map = new HashMap<String, Value>();
        for (Map.Entry<Key, Value> entry : this.fields.entrySet()) {
            map.put(entry.getKey().toString(), entry.getValue());
        }
        return map.entrySet();
    }

    public Set<Map.Entry<Key, Value>> getFields() {
        return this.fields.entrySet();
    }

    public void normalizeName(Key key, String fullyQualifiedName) {
        Value value = this.fields.remove(key);
        if (value == null) {
            throw new IllegalStateException("Could not find option for key=" + key);
        }
        this.fields.put(Key.extension(fullyQualifiedName), value);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<Key, Value> keyValueEntry : this.fields.entrySet()) {
            Key key = keyValueEntry.getKey();
            Value value = keyValueEntry.getValue();
            if (!key.isExtension()) {
                result.put(key.getName(), this.transformValueToObject(value));
                continue;
            }
            String fullName = key.getName().substring(1);
            result.put("(" + fullName + ")", this.transformValueToObject(value));
        }
        return result;
    }

    private Object transformValueToObject(Value value) {
        switch (value.getType()) {
            case BOOLEAN: {
                return value.getBoolean();
            }
            case INTEGER: {
                return value.getInt64();
            }
            case FLOAT: {
                return value.getDouble();
            }
            case STRING: {
                return value.getString();
            }
            case ENUM: {
                return value.getEnumName();
            }
            case MESSAGE: {
                return null;
            }
        }
        return value;
    }

    public static class Value
    extends AbstractElement {
        private final Element parent;
        private final Type type;
        private final boolean bool;
        private final long number;
        private final double floatNumber;
        private final String string;
        private final String enumName;
        private final DynamicMessage message;

        private Value(SourceCodeLocation sourceCodeLocation, Type type, Object value, Element parent) {
            this.parent = parent;
            this.sourceCodeLocation = sourceCodeLocation;
            this.type = type;
            boolean b = false;
            double f = 0.0;
            long l = 0L;
            String e = null;
            String s = null;
            DynamicMessage m = null;
            switch (type) {
                case BOOLEAN: {
                    b = (Boolean)value;
                    break;
                }
                case INTEGER: {
                    l = (Long)value;
                    break;
                }
                case FLOAT: {
                    f = (Double)value;
                    break;
                }
                case STRING: {
                    s = (String)value;
                    break;
                }
                case ENUM: {
                    e = (String)value;
                    break;
                }
                case MESSAGE: {
                    m = (DynamicMessage)value;
                    break;
                }
                default: {
                    throw new IllegalStateException(String.valueOf((Object)type));
                }
            }
            this.bool = b;
            this.number = l;
            this.floatNumber = f;
            this.string = s;
            this.enumName = e;
            this.message = m;
        }

        public static Value createString(String value) {
            return new Value(SourceCodeLocation.UNKNOWN, Type.STRING, value, null);
        }

        public static Value createString(SourceCodeLocation sourceCodeLocation, String value) {
            return new Value(sourceCodeLocation, Type.STRING, value, null);
        }

        public static Value createBoolean(boolean value) {
            return new Value(SourceCodeLocation.UNKNOWN, Type.BOOLEAN, value, null);
        }

        public static Value createBoolean(SourceCodeLocation sourceCodeLocation, boolean value) {
            return new Value(sourceCodeLocation, Type.BOOLEAN, value, null);
        }

        public static Value createInteger(long value) {
            return new Value(SourceCodeLocation.UNKNOWN, Type.INTEGER, value, null);
        }

        public static Value createInteger(SourceCodeLocation sourceCodeLocation, long value) {
            return new Value(sourceCodeLocation, Type.INTEGER, value, null);
        }

        public static Value createMessage(DynamicMessage value) {
            return new Value(SourceCodeLocation.UNKNOWN, Type.MESSAGE, value, null);
        }

        public static Value createMessage(SourceCodeLocation sourceCodeLocation, DynamicMessage value) {
            return new Value(sourceCodeLocation, Type.MESSAGE, value, null);
        }

        public static Value createFloat(double value) {
            return new Value(SourceCodeLocation.UNKNOWN, Type.FLOAT, value, null);
        }

        public static Value createFloat(SourceCodeLocation sourceCodeLocation, double value) {
            return new Value(sourceCodeLocation, Type.FLOAT, value, null);
        }

        public static Value createEnum(String value) {
            return new Value(SourceCodeLocation.UNKNOWN, Type.ENUM, value, null);
        }

        public static Value createEnum(SourceCodeLocation sourceCodeLocation, String value) {
            return new Value(sourceCodeLocation, Type.ENUM, value, null);
        }

        @Override
        public Element getParent() {
            return this.parent;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            switch (this.type) {
                case BOOLEAN: {
                    return String.valueOf(this.bool);
                }
                case INTEGER: {
                    return String.valueOf(this.number);
                }
                case FLOAT: {
                    return String.valueOf(this.floatNumber);
                }
                case STRING: {
                    return String.valueOf(this.string);
                }
                case ENUM: {
                    return String.valueOf(this.enumName);
                }
                case MESSAGE: {
                    return this.message.toString();
                }
            }
            throw new IllegalStateException(String.valueOf((Object)this.type));
        }

        public boolean getBoolean() {
            Preconditions.checkState((boolean)this.isBooleanType(), (String)"%s is not a boolean", (Object[])new Object[]{this});
            return this.bool;
        }

        public boolean isBooleanType() {
            return this.type == Type.BOOLEAN;
        }

        public long getInt64() {
            Preconditions.checkState((boolean)this.isIntegerType(), (String)"%s is not a number", (Object[])new Object[]{this});
            return this.number;
        }

        public int getInt32() {
            Preconditions.checkState((boolean)this.isIntegerType(), (String)"%s is not a number", (Object[])new Object[]{this});
            Preconditions.checkState((this.number <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"%d does not fit into int32", (Object[])new Object[]{this.number});
            Preconditions.checkState((this.number >= Integer.MIN_VALUE ? 1 : 0) != 0, (String)"%d does not fit into int32", (Object[])new Object[]{this.number});
            return (int)this.number;
        }

        public double getDouble() {
            return this.floatNumber;
        }

        public boolean isIntegerType() {
            return this.type == Type.INTEGER;
        }

        public String getString() {
            Preconditions.checkState((boolean)this.isStringType(), (String)"%s is not a string", (Object[])new Object[]{this});
            return this.string;
        }

        public boolean isStringType() {
            return this.type == Type.STRING;
        }

        public String getEnumName() {
            Preconditions.checkState((boolean)this.isEnumType(), (String)"%s is not a enum", (Object[])new Object[]{this});
            return this.enumName;
        }

        public boolean isEnumType() {
            return this.type == Type.ENUM;
        }

        public DynamicMessage getMessage() {
            Preconditions.checkState((boolean)this.isMessageType(), (String)"%s is not a message", (Object[])new Object[]{this});
            return this.message;
        }

        public boolean isMessageType() {
            return this.type == Type.MESSAGE;
        }

        public static enum Type {
            BOOLEAN,
            INTEGER,
            FLOAT,
            STRING,
            ENUM,
            MESSAGE;


            public String toString() {
                return this.name().toLowerCase();
            }
        }
    }

    public static class Key {
        private final String name;
        private final boolean extension;

        public Key(String name, boolean extension) {
            this.name = name;
            this.extension = extension;
        }

        public static Key field(String name) {
            return new Key(name, false);
        }

        public static Key extension(String name) {
            return new Key(name, true);
        }

        public String getName() {
            return this.name;
        }

        public boolean isExtension() {
            return this.extension;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            if (this.extension != key.extension) {
                return false;
            }
            return !(this.name == null ? key.name != null : !this.name.equals(key.name));
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.extension ? 1 : 0);
            return result;
        }

        public String toString() {
            if (this.extension) {
                return '(' + this.name + ')';
            }
            return this.name;
        }
    }
}

