/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import io.protostuff.compiler.model.Enum;
import io.protostuff.compiler.model.Message;
import io.protostuff.compiler.model.Proto;
import io.protostuff.compiler.model.Service;
import io.protostuff.compiler.model.UserTypeContainer;
import io.protostuff.compiler.parser.ProtoContext;
import java.util.ArrayList;
import java.util.List;

public class ProtoWalker {
    private final ProtoContext context;
    private final Proto proto;
    private final List<Processor<Proto>> protoProcessors = new ArrayList<Processor<Proto>>();
    private final List<Processor<Message>> messageProcessors = new ArrayList<Processor<Message>>();
    private final List<Processor<Enum>> enumProcessors = new ArrayList<Processor<Enum>>();
    private final List<Processor<Service>> serviceProcessors = new ArrayList<Processor<Service>>();

    public ProtoWalker(ProtoContext protoContext) {
        this.context = protoContext;
        this.proto = protoContext.getProto();
    }

    public static ProtoWalker newInstance(ProtoContext proto) {
        return new ProtoWalker(proto);
    }

    public ProtoWalker onProto(Processor<Proto> processor) {
        this.protoProcessors.add(processor);
        return this;
    }

    public ProtoWalker onMessage(Processor<Message> processor) {
        this.messageProcessors.add(processor);
        return this;
    }

    public ProtoWalker onEnum(Processor<Enum> processor) {
        this.enumProcessors.add(processor);
        return this;
    }

    public ProtoWalker onService(Processor<Service> processor) {
        this.serviceProcessors.add(processor);
        return this;
    }

    public void walk() {
        for (Processor<Proto> protoProcessor : this.protoProcessors) {
            protoProcessor.run(this.context, this.proto);
        }
        this.walk(this.proto);
    }

    private void walk(Proto container) {
        List<Service> services = container.getServices();
        for (Processor<Service> serviceProcessor : this.serviceProcessors) {
            for (Service service : services) {
                serviceProcessor.run(this.context, service);
            }
        }
        this.walk((UserTypeContainer)container);
    }

    private void walk(UserTypeContainer container) {
        List<Message> messages = container.getMessages();
        for (Processor<Message> messageProcessor : this.messageProcessors) {
            for (Message message : messages) {
                messageProcessor.run(this.context, message);
            }
        }
        List<Enum> enums = container.getEnums();
        for (Processor<Enum> enumProcessor : this.enumProcessors) {
            for (Enum anEnum : enums) {
                enumProcessor.run(this.context, anEnum);
            }
        }
    }

    public static interface Processor<T> {
        public void run(ProtoContext var1, T var2);
    }
}

