/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.model.util;

import io.protostuff.compiler.model.Enum;
import io.protostuff.compiler.model.Message;
import io.protostuff.compiler.model.Proto;
import io.protostuff.compiler.model.UserTypeContainer;

public class ProtoTreeWalker {
    public static final ProtoTreeWalker DEFAULT = new ProtoTreeWalker();

    public void walk(Proto proto, ProtoOperation protoOperation, MessageOperation messageOperation, EnumOperation enumOperation) {
        protoOperation.process(proto);
        proto.getEnums().forEach(enumOperation::process);
        proto.getMessages().forEach(messageOperation::process);
        for (Message message : proto.getMessages()) {
            this.walk(message, messageOperation, enumOperation);
        }
    }

    public void walk(UserTypeContainer container, MessageOperation messageOperation, EnumOperation enumOperation) {
        container.getMessages().forEach(messageOperation::process);
        container.getEnums().forEach(enumOperation::process);
        for (Message message : container.getMessages()) {
            this.walk(message, messageOperation, enumOperation);
        }
    }

    public static interface EnumOperation {
        public void process(Enum var1);
    }

    public static interface MessageOperation {
        public void process(Message var1);
    }

    public static interface ProtoOperation {
        public void process(Proto var1);
    }
}

