/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.model;

import com.google.common.base.MoreObjects;
import io.protostuff.compiler.model.AbstractDescriptor;
import io.protostuff.compiler.model.DescriptorType;
import io.protostuff.compiler.model.Proto;
import io.protostuff.compiler.model.ServiceMethod;
import io.protostuff.compiler.model.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Service
extends AbstractDescriptor
implements Type {
    private final Proto parent;
    private Proto proto;
    private String fullyQualifiedName;
    private List<ServiceMethod> methods;

    public Service(Proto parent) {
        this.parent = parent;
    }

    @Override
    public Proto getParent() {
        return this.parent;
    }

    @Override
    public DescriptorType getDescriptorType() {
        return DescriptorType.SERVICE;
    }

    public Proto getProto() {
        return this.proto;
    }

    public void setProto(Proto proto) {
        this.proto = proto;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public List<ServiceMethod> getMethods() {
        if (this.methods == null) {
            return Collections.emptyList();
        }
        return this.methods;
    }

    public void setMethods(List<ServiceMethod> methods) {
        this.methods = methods;
    }

    public ServiceMethod getMethod(String name) {
        for (ServiceMethod serviceMethod : this.getMethods()) {
            if (!serviceMethod.getName().equals(name)) continue;
            return serviceMethod;
        }
        return null;
    }

    public void addMethod(ServiceMethod method) {
        if (this.methods == null) {
            this.methods = new ArrayList<ServiceMethod>();
        }
        this.methods.add(method);
    }

    public String getCanonicalName() {
        return this.fullyQualifiedName.substring(1);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("fullyQualifiedName", (Object)this.fullyQualifiedName).add("methods", this.methods).add("options", (Object)this.options).toString();
    }
}

