/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.protostuff.compiler.model.Module;
import io.protostuff.compiler.model.Proto;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableModule
implements Module {
    private final String name;
    private final ImmutableList<Proto> protos;
    private final String output;
    private final ImmutableMap<String, Object> options;

    private ImmutableModule(String name, ImmutableList<Proto> protos, String output, ImmutableMap<String, Object> options) {
        this.name = name;
        this.protos = protos;
        this.output = output;
        this.options = options;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ImmutableList<Proto> getProtos() {
        return this.protos;
    }

    @Override
    public String getOutput() {
        return this.output;
    }

    public ImmutableMap<String, Object> getOptions() {
        return this.options;
    }

    public final ImmutableModule withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return new ImmutableModule(newValue, this.protos, this.output, this.options);
    }

    public final ImmutableModule withProtos(Proto ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableModule(this.name, (ImmutableList<Proto>)newValue, this.output, this.options);
    }

    public final ImmutableModule withProtos(Iterable<? extends Proto> elements) {
        if (this.protos == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableModule(this.name, (ImmutableList<Proto>)newValue, this.output, this.options);
    }

    public final ImmutableModule withOutput(String value) {
        if (this.output == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return new ImmutableModule(this.name, this.protos, newValue, this.options);
    }

    public final ImmutableModule withOptions(Map<String, ? extends Object> entries) {
        if (this.options == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableModule(this.name, this.protos, this.output, (ImmutableMap<String, Object>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableModule && this.equalTo((ImmutableModule)another);
    }

    private boolean equalTo(ImmutableModule another) {
        return this.name.equals(another.name) && this.protos.equals(another.protos) && this.output.equals(another.output) && this.options.equals(another.options);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.protos.hashCode();
        h = h * 17 + this.output.hashCode();
        h = h * 17 + this.options.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Module").add("name", (Object)this.name).add("protos", this.protos).add("output", (Object)this.output).add("options", this.options).toString();
    }

    public static ImmutableModule copyOf(Module instance) {
        if (instance instanceof ImmutableModule) {
            return (ImmutableModule)instance;
        }
        return ImmutableModule.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_OUTPUT = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        private ImmutableList.Builder<Proto> protosBuilder = ImmutableList.builder();
        @Nullable
        private String output;
        private ImmutableMap.Builder<String, Object> optionsBuilder = ImmutableMap.builder();

        private Builder() {
        }

        public final Builder from(Module instance) {
            Preconditions.checkNotNull((Object)instance);
            this.name(instance.getName());
            this.addAllProtos(instance.getProtos());
            this.output(instance.getOutput());
            this.putAllOptions(instance.getOptions());
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addProtos(Proto element) {
            this.protosBuilder.add((Object)element);
            return this;
        }

        public final Builder addProtos(Proto ... elements) {
            this.protosBuilder.add((Object[])elements);
            return this;
        }

        public final Builder protos(Iterable<? extends Proto> elements) {
            this.protosBuilder = ImmutableList.builder();
            return this.addAllProtos(elements);
        }

        public final Builder addAllProtos(Iterable<? extends Proto> elements) {
            this.protosBuilder.addAll(elements);
            return this;
        }

        public final Builder output(String output) {
            this.output = (String)Preconditions.checkNotNull((Object)output);
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder putOptions(String key, Object value) {
            this.optionsBuilder.put((Object)key, value);
            return this;
        }

        public final Builder putOptions(Map.Entry<String, ? extends Object> entry) {
            this.optionsBuilder.put(entry);
            return this;
        }

        public final Builder options(Map<String, ? extends Object> entries) {
            this.optionsBuilder = ImmutableMap.builder();
            return this.putAllOptions(entries);
        }

        public final Builder putAllOptions(Map<String, ? extends Object> entries) {
            this.optionsBuilder.putAll(entries);
            return this;
        }

        public ImmutableModule build() throws IllegalStateException {
            this.checkRequiredAttributes();
            return new ImmutableModule(this.name, this.protosBuilder.build(), this.output, this.optionsBuilder.build());
        }

        private boolean nameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean outputIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.outputIsSet()) {
                attributes.add("output");
            }
            return "Cannot build Module, some of required attributes are not set " + attributes;
        }
    }
}

