/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.model;

import com.google.common.base.MoreObjects;
import io.protostuff.compiler.model.AbstractUserType;
import io.protostuff.compiler.model.DescriptorType;
import io.protostuff.compiler.model.EnumConstant;
import io.protostuff.compiler.model.UserTypeContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Enum
extends AbstractUserType {
    protected List<EnumConstant> constants;

    public Enum(UserTypeContainer parent) {
        super(parent);
    }

    public List<EnumConstant> getConstants() {
        if (this.constants == null) {
            return Collections.emptyList();
        }
        return this.constants;
    }

    public void setConstants(List<EnumConstant> constants) {
        this.constants = constants;
    }

    public Set<String> getConstantNames() {
        if (this.constants == null) {
            return Collections.emptySet();
        }
        return this.constants.stream().map(EnumConstant::getName).collect(Collectors.toSet());
    }

    public EnumConstant getConstant(String name) {
        for (EnumConstant enumConstant : this.getConstants()) {
            if (!enumConstant.getName().equals(name)) continue;
            return enumConstant;
        }
        return null;
    }

    public void addConstant(EnumConstant value) {
        if (this.constants == null) {
            this.constants = new ArrayList<EnumConstant>();
        }
        this.constants.add(value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("fullyQualifiedName", (Object)this.fullyQualifiedName).add("constants", this.constants).add("options", (Object)this.options).toString();
    }

    @Override
    public DescriptorType getDescriptorType() {
        return DescriptorType.ENUM;
    }

    @Override
    public boolean isScalar() {
        return true;
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    @Override
    public boolean isMessage() {
        return false;
    }
}

