/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import io.protostuff.compiler.model.Element;
import io.protostuff.compiler.model.Extension;
import io.protostuff.compiler.model.Field;
import io.protostuff.compiler.model.FieldContainer;
import io.protostuff.compiler.model.FieldType;
import io.protostuff.compiler.model.GroupContainer;
import io.protostuff.compiler.model.Message;
import io.protostuff.compiler.model.Oneof;
import io.protostuff.compiler.model.Proto;
import io.protostuff.compiler.model.ScalarFieldType;
import io.protostuff.compiler.model.Service;
import io.protostuff.compiler.model.ServiceMethod;
import io.protostuff.compiler.model.UserType;
import io.protostuff.compiler.model.UserTypeContainer;
import io.protostuff.compiler.parser.ParserException;
import io.protostuff.compiler.parser.ProtoContext;
import io.protostuff.compiler.parser.ProtoContextPostProcessor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;

public class TypeResolverPostProcessor
implements ProtoContextPostProcessor {
    public static final String ILLEGAL_KEY_TYPE = "Illegal key type: %s";

    public static Deque<String> createScopeLookupList(UserTypeContainer container) {
        String namespace = container.getNamespace();
        ArrayDeque<String> scopeLookupList = new ArrayDeque<String>();
        int end = 0;
        while (end >= 0) {
            if ((end = namespace.indexOf(46, end)) < 0) continue;
            String scope = namespace.substring(0, ++end);
            scopeLookupList.addFirst(scope);
        }
        return scopeLookupList;
    }

    @Override
    public void process(ProtoContext context) {
        this.resolveTypeReferences(context);
    }

    private void resolveTypeReferences(ProtoContext context) {
        Proto proto = context.getProto();
        Deque<String> scopeLookupList = TypeResolverPostProcessor.createScopeLookupList(proto);
        for (Service service : proto.getServices()) {
            for (ServiceMethod method : service.getMethods()) {
                String argTypeName;
                FieldType argType = this.resolveFieldType(method, context, scopeLookupList, argTypeName = method.getArgTypeName());
                if (!(argType instanceof Message)) {
                    String format = "Cannot use '%s' as a service method argument type: not a message";
                    throw new ParserException(method, format, argType.getName());
                }
                method.setArgType((Message)argType);
                String returnTypeName = method.getReturnTypeName();
                FieldType returnType = this.resolveFieldType(method, context, scopeLookupList, returnTypeName);
                if (!(returnType instanceof Message)) {
                    String format = "Cannot use '%s' as a service method return type: not a message";
                    throw new ParserException(method, format, returnType.getName());
                }
                method.setReturnType((Message)returnType);
            }
        }
        this.resolveTypeReferences(context, scopeLookupList, proto);
    }

    private void resolveTypeReferences(ProtoContext context, Deque<String> scopeLookupList, UserTypeContainer container) {
        for (Extension extension : container.getDeclaredExtensions()) {
            String extendeeName;
            UserType type = this.resolveUserType(extension, context, scopeLookupList, extendeeName = extension.getExtendeeName());
            if (!(type instanceof Message)) {
                throw new ParserException(extension, "Cannot extend '%s': not a message", type.getName());
            }
            Message extendee = (Message)type;
            extension.setExtendee(extendee);
            for (Field field : extension.getFields()) {
                if (field.getType() != null) continue;
                String typeName = field.getTypeName();
                FieldType fieldType = this.resolveFieldType(field, context, scopeLookupList, typeName);
                field.setType(fieldType);
            }
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.addAll(container.getMessages());
        if (container instanceof GroupContainer) {
            messages.addAll(((GroupContainer)((Object)container)).getGroups());
        }
        for (Extension extension : container.getDeclaredExtensions()) {
            messages.addAll(extension.getGroups());
        }
        for (Message message : messages) {
            String root = scopeLookupList.peek();
            scopeLookupList.push(root + message.getName() + ".");
            this.updateFieldTypes(context, scopeLookupList, message);
            for (Oneof oneof : message.getOneofs()) {
                this.updateFieldTypes(context, scopeLookupList, oneof);
            }
            this.resolveTypeReferences(context, scopeLookupList, message);
            scopeLookupList.pop();
        }
    }

    private void updateFieldTypes(ProtoContext context, Deque<String> scopeLookupList, FieldContainer fieldContainer) {
        fieldContainer.getFields().stream().filter(field -> field.getType() == null).forEach(field -> {
            String typeName = field.getTypeName();
            FieldType fieldType = this.resolveFieldType((Element)field, context, scopeLookupList, typeName);
            field.setType(fieldType);
        });
    }

    private FieldType resolveFieldType(Element source, ProtoContext context, Deque<String> scopeLookupList, String typeName) {
        ScalarFieldType scalarFieldType = ScalarFieldType.getByName(typeName);
        if (scalarFieldType != null) {
            return scalarFieldType;
        }
        return this.resolveUserType(source, context, scopeLookupList, typeName);
    }

    private UserType resolveUserType(Element source, ProtoContext context, Deque<String> scopeLookupList, String typeName) {
        UserType fieldType;
        block3: {
            block2: {
                fieldType = null;
                if (!typeName.startsWith(".")) break block2;
                UserType type = (UserType)context.resolve(typeName);
                if (type == null) break block3;
                fieldType = type;
                break block3;
            }
            for (String scope : scopeLookupList) {
                String fullTypeName = scope + typeName;
                UserType type = (UserType)context.resolve(fullTypeName);
                if (type == null) continue;
                fieldType = type;
                break;
            }
        }
        if (fieldType == null) {
            String format = "Unresolved reference: '%s'";
            throw new ParserException(source, format, typeName);
        }
        return fieldType;
    }
}

