/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.protostuff.compiler.model.ModuleConfiguration;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableModuleConfiguration
implements ModuleConfiguration {
    private final String name;
    private final ImmutableList<Path> includePaths;
    private final ImmutableList<String> protoFiles;
    private final String generator;
    private final String output;
    private final ImmutableMap<String, String> options;

    private ImmutableModuleConfiguration(String name, ImmutableList<Path> includePaths, ImmutableList<String> protoFiles, String generator, String output, ImmutableMap<String, String> options) {
        this.name = name;
        this.includePaths = includePaths;
        this.protoFiles = protoFiles;
        this.generator = generator;
        this.output = output;
        this.options = options;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ImmutableList<Path> getIncludePaths() {
        return this.includePaths;
    }

    public ImmutableList<String> getProtoFiles() {
        return this.protoFiles;
    }

    @Override
    public String getGenerator() {
        return this.generator;
    }

    @Override
    public String getOutput() {
        return this.output;
    }

    public ImmutableMap<String, String> getOptions() {
        return this.options;
    }

    public final ImmutableModuleConfiguration withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return new ImmutableModuleConfiguration(newValue, this.includePaths, this.protoFiles, this.generator, this.output, this.options);
    }

    public final ImmutableModuleConfiguration withIncludePaths(Path ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableModuleConfiguration(this.name, (ImmutableList<Path>)newValue, this.protoFiles, this.generator, this.output, this.options);
    }

    public final ImmutableModuleConfiguration withIncludePaths(Iterable<? extends Path> elements) {
        if (this.includePaths == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableModuleConfiguration(this.name, (ImmutableList<Path>)newValue, this.protoFiles, this.generator, this.output, this.options);
    }

    public final ImmutableModuleConfiguration withProtoFiles(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableModuleConfiguration(this.name, this.includePaths, (ImmutableList<String>)newValue, this.generator, this.output, this.options);
    }

    public final ImmutableModuleConfiguration withProtoFiles(Iterable<String> elements) {
        if (this.protoFiles == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableModuleConfiguration(this.name, this.includePaths, (ImmutableList<String>)newValue, this.generator, this.output, this.options);
    }

    public final ImmutableModuleConfiguration withGenerator(String value) {
        if (this.generator == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return new ImmutableModuleConfiguration(this.name, this.includePaths, this.protoFiles, newValue, this.output, this.options);
    }

    public final ImmutableModuleConfiguration withOutput(String value) {
        if (this.output == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return new ImmutableModuleConfiguration(this.name, this.includePaths, this.protoFiles, this.generator, newValue, this.options);
    }

    public final ImmutableModuleConfiguration withOptions(Map<String, ? extends String> entries) {
        if (this.options == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableModuleConfiguration(this.name, this.includePaths, this.protoFiles, this.generator, this.output, (ImmutableMap<String, String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableModuleConfiguration && this.equalTo((ImmutableModuleConfiguration)another);
    }

    private boolean equalTo(ImmutableModuleConfiguration another) {
        return this.name.equals(another.name) && this.includePaths.equals(another.includePaths) && this.protoFiles.equals(another.protoFiles) && this.generator.equals(another.generator) && this.output.equals(another.output) && this.options.equals(another.options);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.includePaths.hashCode();
        h = h * 17 + this.protoFiles.hashCode();
        h = h * 17 + this.generator.hashCode();
        h = h * 17 + this.output.hashCode();
        h = h * 17 + this.options.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ModuleConfiguration").add("name", (Object)this.name).add("includePaths", this.includePaths).add("protoFiles", this.protoFiles).add("generator", (Object)this.generator).add("output", (Object)this.output).add("options", this.options).toString();
    }

    public static ImmutableModuleConfiguration copyOf(ModuleConfiguration instance) {
        if (instance instanceof ImmutableModuleConfiguration) {
            return (ImmutableModuleConfiguration)instance;
        }
        return ImmutableModuleConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_GENERATOR = 2L;
        private static final long INIT_BIT_OUTPUT = 4L;
        private long initBits = 7L;
        @Nullable
        private String name;
        private ImmutableList.Builder<Path> includePathsBuilder = ImmutableList.builder();
        private ImmutableList.Builder<String> protoFilesBuilder = ImmutableList.builder();
        @Nullable
        private String generator;
        @Nullable
        private String output;
        private ImmutableMap.Builder<String, String> optionsBuilder = ImmutableMap.builder();

        private Builder() {
        }

        public final Builder from(ModuleConfiguration instance) {
            Preconditions.checkNotNull((Object)instance);
            this.name(instance.getName());
            this.addAllIncludePaths(instance.getIncludePaths());
            this.addAllProtoFiles(instance.getProtoFiles());
            this.generator(instance.getGenerator());
            this.output(instance.getOutput());
            this.putAllOptions(instance.getOptions());
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addIncludePaths(Path element) {
            this.includePathsBuilder.add((Object)element);
            return this;
        }

        public final Builder addIncludePaths(Path ... elements) {
            this.includePathsBuilder.add((Object[])elements);
            return this;
        }

        public final Builder includePaths(Iterable<? extends Path> elements) {
            this.includePathsBuilder = ImmutableList.builder();
            return this.addAllIncludePaths(elements);
        }

        public final Builder addAllIncludePaths(Iterable<? extends Path> elements) {
            this.includePathsBuilder.addAll(elements);
            return this;
        }

        public final Builder addProtoFiles(String element) {
            this.protoFilesBuilder.add((Object)element);
            return this;
        }

        public final Builder addProtoFiles(String ... elements) {
            this.protoFilesBuilder.add((Object[])elements);
            return this;
        }

        public final Builder protoFiles(Iterable<String> elements) {
            this.protoFilesBuilder = ImmutableList.builder();
            return this.addAllProtoFiles(elements);
        }

        public final Builder addAllProtoFiles(Iterable<String> elements) {
            this.protoFilesBuilder.addAll(elements);
            return this;
        }

        public final Builder generator(String generator) {
            this.generator = (String)Preconditions.checkNotNull((Object)generator);
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder output(String output) {
            this.output = (String)Preconditions.checkNotNull((Object)output);
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder putOptions(String key, String value) {
            this.optionsBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putOptions(Map.Entry<String, ? extends String> entry) {
            this.optionsBuilder.put(entry);
            return this;
        }

        public final Builder options(Map<String, ? extends String> entries) {
            this.optionsBuilder = ImmutableMap.builder();
            return this.putAllOptions(entries);
        }

        public final Builder putAllOptions(Map<String, ? extends String> entries) {
            this.optionsBuilder.putAll(entries);
            return this;
        }

        public ImmutableModuleConfiguration build() throws IllegalStateException {
            this.checkRequiredAttributes();
            return new ImmutableModuleConfiguration(this.name, this.includePathsBuilder.build(), this.protoFilesBuilder.build(), this.generator, this.output, this.optionsBuilder.build());
        }

        private boolean nameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean generatorIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean outputIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.generatorIsSet()) {
                attributes.add("generator");
            }
            if (!this.outputIsSet()) {
                attributes.add("output");
            }
            return "Cannot build ModuleConfiguration, some of required attributes are not set " + attributes;
        }
    }
}

