package io.protostuff.compiler.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link Module}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableModule.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "Module"})
@Immutable
public final class ImmutableModule implements Module {
  private final String name;
  private final ImmutableList<Proto> protos;
  private final String output;
  private final ImmutableMap<String, String> options;

  private ImmutableModule(
      String name,
      ImmutableList<Proto> protos,
      String output,
      ImmutableMap<String, String> options) {
    this.name = name;
    this.protos = protos;
    this.output = output;
    this.options = options;
  }

  /**
   * @return value of {@code name} attribute
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return value of {@code protos} attribute
   */
  @Override
  public ImmutableList<Proto> getProtos() {
    return protos;
  }

  /**
   * @return value of {@code output} attribute
   */
  @Override
  public String getOutput() {
    return output;
  }

  /**
   * @return value of {@code options} attribute
   */
  @Override
  public ImmutableMap<String, String> getOptions() {
    return options;
  }

  /**
   * Copy current immutable object by setting value for {@link Module#getName() name}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for name
   * @return modified copy of the {@code this} object
   */
  public final ImmutableModule withName(String value) {
    if (this.name == value) return this;
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableModule(newValue, this.protos, this.output, this.options);
  }

  /**
   * Copy current immutable object with elements that replace content of {@link Module#getProtos() protos}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final ImmutableModule withProtos(Proto... elements) {
    ImmutableList<Proto> newValue = ImmutableList.copyOf(elements);
    return new ImmutableModule(this.name, newValue, this.output, this.options);
  }

  /**
   * Copy current immutable object with elements that replace content of {@link Module#getProtos() protos}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of protos elements to set
   * @return modified copy of {@code this} object
   */
  public final ImmutableModule withProtos(Iterable<? extends Proto> elements) {
    if (this.protos == elements) return this;
    ImmutableList<Proto> newValue = ImmutableList.copyOf(elements);
    return new ImmutableModule(this.name, newValue, this.output, this.options);
  }

  /**
   * Copy current immutable object by setting value for {@link Module#getOutput() output}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for output
   * @return modified copy of the {@code this} object
   */
  public final ImmutableModule withOutput(String value) {
    if (this.output == value) return this;
    String newValue = Preconditions.checkNotNull(value);
    return new ImmutableModule(this.name, this.protos, newValue, this.options);
  }

  /**
   * Copy current immutable object by replacing {@link Module#getOptions() options} map with specified map.
   * Nulls are not permitted as keys or values.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries to be added to options map
   * @return modified copy of {@code this} object
   */
  public final ImmutableModule withOptions(Map<String, ? extends String> entries) {
    if (this.options == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableModule(this.name, this.protos, this.output, newValue);
  }

  /**
   * This instance is equal to instances of {@code ImmutableModule} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableModule
        && equalTo((ImmutableModule) another);
  }

  private boolean equalTo(ImmutableModule another) {
    return name.equals(another.name)
        && protos.equals(another.protos)
        && output.equals(another.output)
        && options.equals(another.options);
  }

  /**
   * Computes hash code from attributes: {@code name}, {@code protos}, {@code output}, {@code options}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + protos.hashCode();
    h = h * 17 + output.hashCode();
    h = h * 17 + options.hashCode();
    return h;
  }

  /**
   * Prints immutable value {@code Module...} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Module")
        .add("name", name)
        .add("protos", protos)
        .add("output", output)
        .add("options", options)
        .toString();
  }

  /**
   * Creates immutable copy of {@link Module}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable Module instance
   */
  public static ImmutableModule copyOf(Module instance) {
    if (instance instanceof ImmutableModule) {
      return (ImmutableModule) instance;
    }
    return ImmutableModule.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link io.protostuff.compiler.model.ImmutableModule ImmutableModule}.
   * @return new ImmutableModule builder
   */
  public static ImmutableModule.Builder builder() {
    return new ImmutableModule.Builder();
  }

  /**
   * Builds instances of {@link io.protostuff.compiler.model.ImmutableModule ImmutableModule}.
   * Initialize attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>{@code Builder} is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_OUTPUT = 0x2L;
    private long initBits = 0x3;

    private @Nullable String name;
    private ImmutableList.Builder<Proto> protosBuilder = ImmutableList.builder();
    private @Nullable String output;
    private ImmutableMap.Builder<String, String> optionsBuilder = ImmutableMap.builder();

    private Builder() {}

    /**
     * Fill builder with attribute values from provided {@link Module} instance.
     * Regular attribute values will be replaced with ones of an instance.
     * Instance's absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(Module instance) {
      Preconditions.checkNotNull(instance);
      name(instance.getName());
      addAllProtos(instance.getProtos());
      output(instance.getOutput());
      putAllOptions(instance.getOptions());
      return this;
    }

    /**
     * Initializes value for {@link Module#getName() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name);
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Adds one element to {@link Module#getProtos() protos} list.
     * @param element protos element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addProtos(Proto element) {
      protosBuilder.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Module#getProtos() protos} list.
     * @param elements array of protos elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addProtos(Proto... elements) {
      protosBuilder.add(elements);
      return this;
    }

    /**
     * Sets or replaces all elements for {@link Module#getProtos() protos} list.
     * @param elements iterable of protos elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder protos(Iterable<? extends Proto> elements) {
      protosBuilder = ImmutableList.builder();
      return addAllProtos(elements);
    }

    /**
     * Adds elements to {@link Module#getProtos() protos} list.
     * @param elements iterable of protos elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllProtos(Iterable<? extends Proto> elements) {
      protosBuilder.addAll(elements);
      return this;
    }

    /**
     * Initializes value for {@link Module#getOutput() output}.
     * @param output value for output
     * @return {@code this} builder for chained invocation
     */
    public final Builder output(String output) {
      this.output = Preconditions.checkNotNull(output);
      initBits &= ~INIT_BIT_OUTPUT;
      return this;
    }

    /**
     * Put one entry to {@link Module#getOptions() options} map.
     * @param key the key in options map
     * @param value the associated value in options map
     * @return {@code this} builder for chained invocation
     */
    public final Builder putOptions(String key, String value) {
      optionsBuilder.put(key, value);
      return this;
    }

    /**
     * Put one entry to {@link Module#getOptions() options} map. Nulls are not permitted
     * @param entry the key and value entry
     * @return {@code this} builder for chained invocation
     */
    public final Builder putOptions(Map.Entry<String, ? extends String> entry) {
      optionsBuilder.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from specified map as entries for {@link Module#getOptions() options} map. Nulls are not permitted
     * @param entries to be added to options map
     * @return {@code this} builder for chained invocation
     */
    public final Builder options(Map<String, ? extends String> entries) {
      optionsBuilder = ImmutableMap.builder();
      return putAllOptions(entries);
    }

    /**
     * Put all mappings from specified map as entries to {@link Module#getOptions() options} map. Nulls are not permitted
     * @param entries to be added to options map
     * @return {@code this} builder for chained invocation
     */
    public final Builder putAllOptions(Map<String, ? extends String> entries) {
      optionsBuilder.putAll(entries);
      return this;
    }
    /**
     * Builds new {@link io.protostuff.compiler.model.ImmutableModule ImmutableModule}.
     * @return immutable instance of Module
     * @throws exception {@code java.lang.IllegalStateException} if any required attributes are missing
     */
    public ImmutableModule build()
        throws IllegalStateException {
      checkRequiredAttributes();
      return new ImmutableModule(name, protosBuilder.build(), output, optionsBuilder.build());
    }

    private boolean nameIsSet() {
      return (initBits & INIT_BIT_NAME) == 0;
    }

    private boolean outputIsSet() {
      return (initBits & INIT_BIT_OUTPUT) == 0;
    }

    private void checkRequiredAttributes() throws IllegalStateException {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if (!nameIsSet()) attributes.add("name");
      if (!outputIsSet()) attributes.add("output");
      return "Cannot build Module, some of required attributes are not set " + attributes;
    }
  }
}
