/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.parser;

public class Mutable<T> {
    private T current;
    private T last;

    public Mutable(T value) {
        if (value == null) {
            throw new IllegalArgumentException("The arg 'value' cannot be null.");
        }
        this.current = value;
    }

    public void override(T newValue) {
        if (this.last == null) {
            this.last = this.current;
            this.current = newValue;
        }
    }

    public void reset() {
        if (this.last != null) {
            this.current = this.last;
            this.last = null;
        }
    }

    public T getValue() {
        return this.current;
    }

    public T getLast() {
        return this.last;
    }

    public boolean isOverridden() {
        return this.last != null;
    }
}

