/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.parser;

import io.protostuff.parser.Field;
import io.protostuff.parser.Message;
import io.protostuff.parser.Proto;

public class MessageField
extends Field<Message> {
    Message message;

    public MessageField() {
        super(false);
    }

    public MessageField(Message message) {
        this();
        this.message = message;
    }

    public Message getMessage() {
        return this.message;
    }

    @Override
    public String getJavaType() {
        StringBuilder buffer = new StringBuilder();
        Message.computeName(this.message, this.owner, buffer);
        return buffer.toString();
    }

    public String getRegularType() {
        String javaType = this.getJavaType();
        Proto messageProto = this.message.getProto();
        String javaPackage = messageProto.getJavaPackageName();
        String protoPackage = messageProto.getPackageName();
        if (javaType.startsWith(javaPackage) && !javaPackage.equals(protoPackage)) {
            return javaType.replace(javaPackage, protoPackage);
        }
        return javaType;
    }

    @Override
    public String getDefaultValueAsString() {
        return "null";
    }

    @Override
    public boolean isDelimited() {
        return true;
    }

    public boolean isSamePackage() {
        return this.getOwner().getProto() == this.getMessage().getProto();
    }

    public String getRelativePath() {
        if (this.isSamePackage()) {
            return "";
        }
        String currentPackage = this.getOwner().getProto().getPackageName();
        String targetPackage = this.getMessage().getProto().getPackageName();
        String path = "../";
        int idx = currentPackage.indexOf(46);
        while (idx != -1) {
            path = path + "../";
            idx = currentPackage.indexOf(46, idx + 1);
        }
        return path + targetPackage.replace('.', '/') + "/";
    }

    @Override
    public String getProtoType() {
        return this.getRegularType();
    }
}

