/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.parser;

import io.protostuff.parser.EnumGroup;
import io.protostuff.parser.Message;
import io.protostuff.parser.Proto;
import io.protostuff.parser.ProtoParserTest;
import io.protostuff.parser.ProtoUtil;
import java.io.File;
import junit.framework.TestCase;

public class OptionTest
extends TestCase {
    public void testIt() throws Exception {
        File f = ProtoParserTest.getFile("io/protostuff/parser/test_options.proto");
        OptionTest.assertTrue((boolean)f.exists());
        Proto proto = new Proto(f);
        ProtoUtil.loadFrom((File)f, (Proto)proto);
        Message aMessage = proto.getMessage("AMessage");
        OptionTest.assertNotNull((Object)aMessage);
        OptionTest.assertEquals((Object)"something", (Object)aMessage.getField("anotherMessage").getOption("anOption"));
        OptionTest.assertEquals((Object)Boolean.TRUE, (Object)aMessage.getExtraOption("message_set_wire_format"));
        Message anotherMessage = proto.getMessage("AnotherMessage");
        OptionTest.assertNotNull((Object)anotherMessage);
        OptionTest.assertEquals((Object)"bar", (Object)anotherMessage.getExtraOption("foo"));
        EnumGroup baz = proto.getEnumGroup("Baz");
        OptionTest.assertNotNull((Object)baz);
        OptionTest.assertEquals((Object)Float.valueOf(1.0f), (Object)baz.getExtraOption("random.enum.option"));
        EnumGroup.Value a = baz.getValue("A");
        OptionTest.assertEquals((Object)1, a.getOptions().get("some_int"));
        OptionTest.assertEquals((Object)Boolean.TRUE, a.getOptions().get("some_bool"));
        OptionTest.assertEquals((Object)"foo", a.getOptions().get("some_string"));
        OptionTest.assertEquals((Object)"none", a.getOptions().get("default"));
    }
}

